/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.resource_throughput.ui.editors;

import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.lsat.common.emf.ui.ActionsViewerPane;
import org.eclipse.lsat.resource_throughput.ui.editors.ResourceThroughputEditingDomain;
import org.eclipse.lsat.resource_throughput.ui.editors.ResourceThroughputEditorPart;
import org.eclipse.lsat.resource_throughput.ui.editors.ResourceThroughputEditorPlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.progress.UIJob;

public class ResourceThroughputViewerPane
extends ActionsViewerPane {
    protected final IAction reloadAction = new Action("Reload", ResourceThroughputEditorPlugin.getPlugin().getImageRegistry().getDescriptor(ResourceThroughputEditorPlugin.IMAGE_RELOAD)){

        public void run() {
            ResourceThroughputViewerPane.this.reloadViewer();
        }
    };
    protected final IAction selectPhaseAction = new Action("Select phase", ResourceThroughputEditorPlugin.getPlugin().getImageRegistry().getDescriptor(ResourceThroughputEditorPlugin.IMAGE_FILTER)){

        public void run() {
            ResourceThroughputViewerPane.this.selectPhase();
        }
    };
    private final String title;
    private final Image image;

    public ResourceThroughputViewerPane(String title, Image image, IWorkbenchPage page, ResourceThroughputEditorPart part) {
        super(page, (IWorkbenchPart)part);
        this.title = title;
        this.image = image;
        this.selectPhaseAction.setEnabled(this.domain().getDispatchPhases().length > 1);
    }

    public void showFocus(boolean inFocus) {
        if (inFocus) {
            this.refreshTitle();
        }
        super.showFocus(inFocus);
    }

    public void refreshTitle() {
        this.setTitle(String.valueOf(this.title) + this.getSelectedPhasesString(), this.image);
    }

    public Viewer createViewer(Composite composite) {
        return new TableViewer(composite, 66308);
    }

    protected void refreshViewer() {
        UIJob job = new UIJob("Refreshing editor"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                ResourceThroughputViewerPane.this.getResourceThroughputEditorPart().refresh(true);
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    protected void reloadViewer() {
        UIJob job = new UIJob("Refreshing editor"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                ResourceThroughputViewerPane.this.getResourceThroughputEditorPart().reload();
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    protected void selectPhase() {
        UIJob job = new UIJob("Refreshing editor"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                ResourceThroughputViewerPane.this.askUserForSelection();
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.getMenuManager().insertBefore("actions", this.selectPhaseAction);
        this.getMenuManager().insertAfter("actions", this.reloadAction);
        this.getToolBarManager().insertBefore("actions", this.selectPhaseAction);
        this.getToolBarManager().insertAfter("actions", this.reloadAction);
        this.updateActionBars();
    }

    private String getSelectedPhasesString() {
        if (this.domain().getDispatchPhases().length < 2) {
            return "";
        }
        String[] phases = this.domain().getSelectedDispatchPhases();
        return Stream.of(phases).collect(Collectors.joining(", ", " (showing dispatching phases [", "])"));
    }

    private ResourceThroughputEditorPart getResourceThroughputEditorPart() {
        return (ResourceThroughputEditorPart)this.getPart();
    }

    private ResourceThroughputEditingDomain domain() {
        return (ResourceThroughputEditingDomain)this.getEditingDomain();
    }

    private void askUserForSelection() {
        String[] phases = this.domain().getDispatchPhases();
        if (phases.length > 1) {
            LabelProvider labelProvider = new LabelProvider();
            ListSelectionDialog dialog = new ListSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (Object)this.domain().getDispatchPhases(), (IStructuredContentProvider)ArrayContentProvider.getInstance(), (ILabelProvider)labelProvider, "Select dispatching phase for analysis");
            dialog.setTitle("Dispatching phase(s)");
            dialog.setInitialElementSelections(Arrays.asList(this.domain().getSelectedDispatchPhases()));
            dialog.open();
            if (dialog.getReturnCode() == 0) {
                this.domain().setDispatchPhases((String[])Stream.of(dialog.getResult()).map(Object::toString).toArray(String[]::new));
                this.refreshTitle();
                this.refreshViewer();
            }
        }
    }
}

