/**
 * Copyright (c) 2021 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Do not edit: This file is generated by Xtext
 */
package org.eclipse.lsat.setting.teditor.serializer;

import com.google.inject.Inject;
import expressions.Add;
import expressions.BigDecimalConstant;
import expressions.Declaration;
import expressions.DeclarationRef;
import expressions.Divide;
import expressions.ExpressionsPackage;
import expressions.Multiply;
import expressions.Subtract;
import java.util.Map;
import java.util.Set;
import machine.Import;
import machine.MachinePackage;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.lsat.setting.teditor.services.SettingGrammarAccess;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Parameter;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.serializer.ISerializationContext;
import org.eclipse.xtext.serializer.acceptor.SequenceFeeder;
import org.eclipse.xtext.serializer.sequencer.AbstractDelegatingSemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService.ValueTransient;
import setting.MotionProfileSettings;
import setting.MotionSettings;
import setting.PhysicalLocation;
import setting.PhysicalSettings;
import setting.SettingPackage;
import setting.Settings;
import timing.Array;
import timing.EnumeratedDistribution;
import timing.FixedValue;
import timing.NormalDistribution;
import timing.PertDistribution;
import timing.TimingPackage;
import timing.TriangularDistribution;

@SuppressWarnings("all")
public abstract class AbstractSettingSemanticSequencer extends AbstractDelegatingSemanticSequencer {

    @Inject
    private SettingGrammarAccess grammarAccess;
    
    @Override
    public void sequence(ISerializationContext context, EObject semanticObject) {
        EPackage epackage = semanticObject.eClass().getEPackage();
        ParserRule rule = context.getParserRule();
        Action action = context.getAssignedAction();
        Set<Parameter> parameters = context.getEnabledBooleanParameters();
        if (epackage == ExpressionsPackage.eINSTANCE)
            switch (semanticObject.eClass().getClassifierID()) {
            case ExpressionsPackage.ADD:
                sequence_PlusOrMinus(context, (Add) semanticObject); 
                return; 
            case ExpressionsPackage.BIG_DECIMAL_CONSTANT:
                sequence_Atomic(context, (BigDecimalConstant) semanticObject); 
                return; 
            case ExpressionsPackage.DECLARATION:
                sequence_Declaration(context, (Declaration) semanticObject); 
                return; 
            case ExpressionsPackage.DECLARATION_REF:
                sequence_Atomic(context, (DeclarationRef) semanticObject); 
                return; 
            case ExpressionsPackage.DIVIDE:
                sequence_MulOrDiv(context, (Divide) semanticObject); 
                return; 
            case ExpressionsPackage.MULTIPLY:
                sequence_MulOrDiv(context, (Multiply) semanticObject); 
                return; 
            case ExpressionsPackage.SUBTRACT:
                sequence_PlusOrMinus(context, (Subtract) semanticObject); 
                return; 
            }
        else if (epackage == MachinePackage.eINSTANCE)
            switch (semanticObject.eClass().getClassifierID()) {
            case MachinePackage.IMPORT:
                sequence_Import(context, (Import) semanticObject); 
                return; 
            }
        else if (epackage == SettingPackage.eINSTANCE)
            switch (semanticObject.eClass().getClassifierID()) {
            case SettingPackage.DISTANCE_SETTINGS_MAP_ENTRY:
                sequence_DistanceSettingsMapEntry(context, (Map.Entry & EObject) semanticObject); 
                return; 
            case SettingPackage.LOCATION_SETTINGS_MAP_ENTRY:
                sequence_LocationSettingsMapEntry(context, (Map.Entry & EObject) semanticObject); 
                return; 
            case SettingPackage.MOTION_ARGUMENTS_MAP_ENTRY:
                sequence_MotionArgumentsMapEntry(context, (Map.Entry & EObject) semanticObject); 
                return; 
            case SettingPackage.MOTION_PROFILE_SETTINGS:
                sequence_MotionProfileSettings(context, (MotionProfileSettings) semanticObject); 
                return; 
            case SettingPackage.MOTION_SETTINGS:
                sequence_MotionSettings(context, (MotionSettings) semanticObject); 
                return; 
            case SettingPackage.MOTION_SETTINGS_MAP_ENTRY:
                sequence_MotionSettingsMapEntry(context, (Map.Entry & EObject) semanticObject); 
                return; 
            case SettingPackage.PHYSICAL_LOCATION:
                sequence_PhysicalLocation(context, (PhysicalLocation) semanticObject); 
                return; 
            case SettingPackage.PHYSICAL_SETTINGS:
                sequence_PhysicalSettings(context, (PhysicalSettings) semanticObject); 
                return; 
            case SettingPackage.PROFILE_SETTINGS_MAP_ENTRY:
                sequence_ProfileSettingsMapEntry(context, (Map.Entry & EObject) semanticObject); 
                return; 
            case SettingPackage.SETTINGS:
                sequence_Settings(context, (Settings) semanticObject); 
                return; 
            case SettingPackage.TIMING_SETTINGS_MAP_ENTRY:
                sequence_TimingSettingsMapEntry(context, (Map.Entry & EObject) semanticObject); 
                return; 
            }
        else if (epackage == TimingPackage.eINSTANCE)
            switch (semanticObject.eClass().getClassifierID()) {
            case TimingPackage.ARRAY:
                sequence_Array(context, (Array) semanticObject); 
                return; 
            case TimingPackage.ENUMERATED_DISTRIBUTION:
                sequence_EnumeratedDistribution(context, (EnumeratedDistribution) semanticObject); 
                return; 
            case TimingPackage.FIXED_VALUE:
                sequence_FixedValue(context, (FixedValue) semanticObject); 
                return; 
            case TimingPackage.NORMAL_DISTRIBUTION:
                sequence_NormalDistribution(context, (NormalDistribution) semanticObject); 
                return; 
            case TimingPackage.PERT_DISTRIBUTION:
                sequence_PertDistribution(context, (PertDistribution) semanticObject); 
                return; 
            case TimingPackage.TRIANGULAR_DISTRIBUTION:
                sequence_TriangularDistribution(context, (TriangularDistribution) semanticObject); 
                return; 
            }
        if (errorAcceptor != null)
            errorAcceptor.accept(diagnosticProvider.createInvalidContextOrTypeDiagnostic(semanticObject, context));
    }
    
    /**
     * Contexts:
     *     Timing returns Array
     *     Array returns Array
     *
     * Constraint:
     *     (valuesExp+=Expression valuesExp+=Expression*)
     */
    			protected void sequence_Array(ISerializationContext context, Array semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    
    
    /**
     * Contexts:
     *     Expression returns BigDecimalConstant
     *     PlusOrMinus returns BigDecimalConstant
     *     PlusOrMinus.Add_1_0_0_0 returns BigDecimalConstant
     *     PlusOrMinus.Subtract_1_0_1_0 returns BigDecimalConstant
     *     MulOrDiv returns BigDecimalConstant
     *     MulOrDiv.Multiply_1_0_0_0 returns BigDecimalConstant
     *     MulOrDiv.Divide_1_0_1_0 returns BigDecimalConstant
     *     Primary returns BigDecimalConstant
     *     Atomic returns BigDecimalConstant
     *
     * Constraint:
     *     value=EBigDecimal
     */
    			protected void sequence_Atomic(ISerializationContext context, BigDecimalConstant semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient(semanticObject, ExpressionsPackage.Literals.BIG_DECIMAL_CONSTANT__VALUE) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, ExpressionsPackage.Literals.BIG_DECIMAL_CONSTANT__VALUE));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
    feeder.accept(grammarAccess.getAtomicAccess().getValueEBigDecimalParserRuleCall_0_1_0(), semanticObject.getValue());
    feeder.finish();
    }
    
    
    /**
     * Contexts:
     *     Expression returns DeclarationRef
     *     PlusOrMinus returns DeclarationRef
     *     PlusOrMinus.Add_1_0_0_0 returns DeclarationRef
     *     PlusOrMinus.Subtract_1_0_1_0 returns DeclarationRef
     *     MulOrDiv returns DeclarationRef
     *     MulOrDiv.Multiply_1_0_0_0 returns DeclarationRef
     *     MulOrDiv.Divide_1_0_1_0 returns DeclarationRef
     *     Primary returns DeclarationRef
     *     Atomic returns DeclarationRef
     *
     * Constraint:
     *     declaration=[Declaration|ID]
     */
    			protected void sequence_Atomic(ISerializationContext context, DeclarationRef semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient(semanticObject, ExpressionsPackage.Literals.DECLARATION_REF__DECLARATION) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, ExpressionsPackage.Literals.DECLARATION_REF__DECLARATION));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
    feeder.accept(grammarAccess.getAtomicAccess().getDeclarationDeclarationIDTerminalRuleCall_1_1_0_1(), semanticObject.eGet(ExpressionsPackage.Literals.DECLARATION_REF__DECLARATION, false));
    feeder.finish();
    }
    
    
    /**
     * Contexts:
     *     Declaration returns Declaration
     *
     * Constraint:
     *     (name=ID expression=Expression)
     */
    			protected void sequence_Declaration(ISerializationContext context, Declaration semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient(semanticObject, ExpressionsPackage.Literals.DECLARATION__NAME) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, ExpressionsPackage.Literals.DECLARATION__NAME));
        if (transientValues.isValueTransient(semanticObject, ExpressionsPackage.Literals.DECLARATION__EXPRESSION) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, ExpressionsPackage.Literals.DECLARATION__EXPRESSION));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
    feeder.accept(grammarAccess.getDeclarationAccess().getNameIDTerminalRuleCall_2_0(), semanticObject.getName());
    feeder.accept(grammarAccess.getDeclarationAccess().getExpressionExpressionParserRuleCall_4_0(), semanticObject.getExpression());
    feeder.finish();
    }
    
    
    /**
     * Contexts:
     *     DistanceSettingsMapEntry returns DistanceSettingsMapEntry
     *
     * Constraint:
     *     (key=[Distance|ID] value=Expression)
     */
    			protected <T extends Map.Entry & EObject> void sequence_DistanceSettingsMapEntry(ISerializationContext context, T semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient((EObject) semanticObject, SettingPackage.Literals.DISTANCE_SETTINGS_MAP_ENTRY__KEY) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing((EObject) semanticObject, SettingPackage.Literals.DISTANCE_SETTINGS_MAP_ENTRY__KEY));
        if (transientValues.isValueTransient((EObject) semanticObject, SettingPackage.Literals.DISTANCE_SETTINGS_MAP_ENTRY__VALUE) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing((EObject) semanticObject, SettingPackage.Literals.DISTANCE_SETTINGS_MAP_ENTRY__VALUE));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, (EObject) semanticObject);
    feeder.accept(grammarAccess.getDistanceSettingsMapEntryAccess().getKeyDistanceIDTerminalRuleCall_0_0_1(), semanticObject.eGet(SettingPackage.Literals.DISTANCE_SETTINGS_MAP_ENTRY__KEY, false));
    feeder.accept(grammarAccess.getDistanceSettingsMapEntryAccess().getValueExpressionParserRuleCall_2_0(), semanticObject.getValue());
    feeder.finish();
    }
    
    
    /**
     * Contexts:
     *     Timing returns EnumeratedDistribution
     *     EnumeratedDistribution returns EnumeratedDistribution
     *
     * Constraint:
     *     (valuesExp+=Expression valuesExp+=Expression* defaultExp=Expression?)
     */
    			protected void sequence_EnumeratedDistribution(ISerializationContext context, EnumeratedDistribution semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    
    
    /**
     * Contexts:
     *     Timing returns FixedValue
     *     FixedValue returns FixedValue
     *
     * Constraint:
     *     valueExp=Expression
     */
    			protected void sequence_FixedValue(ISerializationContext context, FixedValue semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient(semanticObject, TimingPackage.Literals.FIXED_VALUE__VALUE_EXP) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, TimingPackage.Literals.FIXED_VALUE__VALUE_EXP));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
    feeder.accept(grammarAccess.getFixedValueAccess().getValueExpExpressionParserRuleCall_0(), semanticObject.getValueExp());
    feeder.finish();
    }
    
    
    /**
     * Contexts:
     *     Import returns Import
     *
     * Constraint:
     *     importURI=STRING
     */
    			protected void sequence_Import(ISerializationContext context, Import semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient(semanticObject, MachinePackage.Literals.IMPORT__IMPORT_URI) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, MachinePackage.Literals.IMPORT__IMPORT_URI));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
    feeder.accept(grammarAccess.getImportAccess().getImportURISTRINGTerminalRuleCall_1_0(), semanticObject.getImportURI());
    feeder.finish();
    }
    
    
    /**
     * Contexts:
     *     LocationSettingsMapEntry returns LocationSettingsMapEntry
     *
     * Constraint:
     *     (key=[Position|ID] value=PhysicalLocation)
     */
    			protected <T extends Map.Entry & EObject> void sequence_LocationSettingsMapEntry(ISerializationContext context, T semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient((EObject) semanticObject, SettingPackage.Literals.LOCATION_SETTINGS_MAP_ENTRY__KEY) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing((EObject) semanticObject, SettingPackage.Literals.LOCATION_SETTINGS_MAP_ENTRY__KEY));
        if (transientValues.isValueTransient((EObject) semanticObject, SettingPackage.Literals.LOCATION_SETTINGS_MAP_ENTRY__VALUE) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing((EObject) semanticObject, SettingPackage.Literals.LOCATION_SETTINGS_MAP_ENTRY__VALUE));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, (EObject) semanticObject);
    feeder.accept(grammarAccess.getLocationSettingsMapEntryAccess().getKeyPositionIDTerminalRuleCall_0_0_1(), semanticObject.eGet(SettingPackage.Literals.LOCATION_SETTINGS_MAP_ENTRY__KEY, false));
    feeder.accept(grammarAccess.getLocationSettingsMapEntryAccess().getValuePhysicalLocationParserRuleCall_1_0(), semanticObject.getValue());
    feeder.finish();
    }
    
    
    /**
     * Contexts:
     *     MotionArgumentsMapEntry returns MotionArgumentsMapEntry
     *
     * Constraint:
     *     (key=ID value=Expression)
     */
    			protected <T extends Map.Entry & EObject> void sequence_MotionArgumentsMapEntry(ISerializationContext context, T semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient((EObject) semanticObject, SettingPackage.Literals.MOTION_ARGUMENTS_MAP_ENTRY__KEY) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing((EObject) semanticObject, SettingPackage.Literals.MOTION_ARGUMENTS_MAP_ENTRY__KEY));
        if (transientValues.isValueTransient((EObject) semanticObject, SettingPackage.Literals.MOTION_ARGUMENTS_MAP_ENTRY__VALUE) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing((EObject) semanticObject, SettingPackage.Literals.MOTION_ARGUMENTS_MAP_ENTRY__VALUE));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, (EObject) semanticObject);
    feeder.accept(grammarAccess.getMotionArgumentsMapEntryAccess().getKeyIDTerminalRuleCall_0_0(), semanticObject.getKey());
    feeder.accept(grammarAccess.getMotionArgumentsMapEntryAccess().getValueExpressionParserRuleCall_2_0(), semanticObject.getValue());
    feeder.finish();
    }
    
    
    /**
     * Contexts:
     *     MotionProfileSettings returns MotionProfileSettings
     *
     * Constraint:
     *     (motionProfile=ID? (motionArguments+=MotionArgumentsMapEntry motionArguments+=MotionArgumentsMapEntry*)?)
     */
    			protected void sequence_MotionProfileSettings(ISerializationContext context, MotionProfileSettings semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    
    
    /**
     * Contexts:
     *     MotionSettingsMapEntry returns MotionSettingsMapEntry
     *
     * Constraint:
     *     (key=[Axis|ID] value=MotionSettings)
     */
    			protected <T extends Map.Entry & EObject> void sequence_MotionSettingsMapEntry(ISerializationContext context, T semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient((EObject) semanticObject, SettingPackage.Literals.MOTION_SETTINGS_MAP_ENTRY__KEY) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing((EObject) semanticObject, SettingPackage.Literals.MOTION_SETTINGS_MAP_ENTRY__KEY));
        if (transientValues.isValueTransient((EObject) semanticObject, SettingPackage.Literals.MOTION_SETTINGS_MAP_ENTRY__VALUE) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing((EObject) semanticObject, SettingPackage.Literals.MOTION_SETTINGS_MAP_ENTRY__VALUE));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, (EObject) semanticObject);
    feeder.accept(grammarAccess.getMotionSettingsMapEntryAccess().getKeyAxisIDTerminalRuleCall_2_0_1(), semanticObject.eGet(SettingPackage.Literals.MOTION_SETTINGS_MAP_ENTRY__KEY, false));
    feeder.accept(grammarAccess.getMotionSettingsMapEntryAccess().getValueMotionSettingsParserRuleCall_4_0(), semanticObject.getValue());
    feeder.finish();
    }
    
    
    /**
     * Contexts:
     *     MotionSettings returns MotionSettings
     *
     * Constraint:
     *     (profileSettings+=ProfileSettingsMapEntry* locationSettings+=LocationSettingsMapEntry* distanceSettings+=DistanceSettingsMapEntry*)
     */
    			protected void sequence_MotionSettings(ISerializationContext context, MotionSettings semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    
    
    /**
     * Contexts:
     *     Expression returns Divide
     *     PlusOrMinus returns Divide
     *     PlusOrMinus.Add_1_0_0_0 returns Divide
     *     PlusOrMinus.Subtract_1_0_1_0 returns Divide
     *     MulOrDiv returns Divide
     *     MulOrDiv.Multiply_1_0_0_0 returns Divide
     *     MulOrDiv.Divide_1_0_1_0 returns Divide
     *     Primary returns Divide
     *
     * Constraint:
     *     (left=MulOrDiv_Divide_1_0_1_0 right=Primary)
     */
    			protected void sequence_MulOrDiv(ISerializationContext context, Divide semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient(semanticObject, ExpressionsPackage.Literals.BINARY_EXPRESSION__LEFT) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, ExpressionsPackage.Literals.BINARY_EXPRESSION__LEFT));
        if (transientValues.isValueTransient(semanticObject, ExpressionsPackage.Literals.BINARY_EXPRESSION__RIGHT) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, ExpressionsPackage.Literals.BINARY_EXPRESSION__RIGHT));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
    feeder.accept(grammarAccess.getMulOrDivAccess().getDivideLeftAction_1_0_1_0(), semanticObject.getLeft());
    feeder.accept(grammarAccess.getMulOrDivAccess().getRightPrimaryParserRuleCall_1_1_0(), semanticObject.getRight());
    feeder.finish();
    }
    
    
    /**
     * Contexts:
     *     Expression returns Multiply
     *     PlusOrMinus returns Multiply
     *     PlusOrMinus.Add_1_0_0_0 returns Multiply
     *     PlusOrMinus.Subtract_1_0_1_0 returns Multiply
     *     MulOrDiv returns Multiply
     *     MulOrDiv.Multiply_1_0_0_0 returns Multiply
     *     MulOrDiv.Divide_1_0_1_0 returns Multiply
     *     Primary returns Multiply
     *
     * Constraint:
     *     (left=MulOrDiv_Multiply_1_0_0_0 right=Primary)
     */
    			protected void sequence_MulOrDiv(ISerializationContext context, Multiply semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient(semanticObject, ExpressionsPackage.Literals.BINARY_EXPRESSION__LEFT) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, ExpressionsPackage.Literals.BINARY_EXPRESSION__LEFT));
        if (transientValues.isValueTransient(semanticObject, ExpressionsPackage.Literals.BINARY_EXPRESSION__RIGHT) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, ExpressionsPackage.Literals.BINARY_EXPRESSION__RIGHT));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
    feeder.accept(grammarAccess.getMulOrDivAccess().getMultiplyLeftAction_1_0_0_0(), semanticObject.getLeft());
    feeder.accept(grammarAccess.getMulOrDivAccess().getRightPrimaryParserRuleCall_1_1_0(), semanticObject.getRight());
    feeder.finish();
    }
    
    
    /**
     * Contexts:
     *     Timing returns NormalDistribution
     *     NormalDistribution returns NormalDistribution
     *
     * Constraint:
     *     (meanExp=Expression sdExp=Expression defaultExp=Expression?)
     */
    			protected void sequence_NormalDistribution(ISerializationContext context, NormalDistribution semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    
    
    /**
     * Contexts:
     *     Timing returns PertDistribution
     *     PertDistribution returns PertDistribution
     *
     * Constraint:
     *     (minExp=Expression maxExp=Expression modeExp=Expression gammaExp=Expression defaultExp=Expression?)
     */
    			protected void sequence_PertDistribution(ISerializationContext context, PertDistribution semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    
    
    /**
     * Contexts:
     *     PhysicalLocation returns PhysicalLocation
     *
     * Constraint:
     *     (defaultExp=Expression | (minExp=Expression? maxExp=Expression? defaultExp=Expression))
     */
    			protected void sequence_PhysicalLocation(ISerializationContext context, PhysicalLocation semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    
    
    /**
     * Contexts:
     *     PhysicalSettings returns PhysicalSettings
     *
     * Constraint:
     *     (
     *         resource=[IResource|ResourceQualifiedName] 
     *         peripheral=[Peripheral|IID] 
     *         timingSettings+=TimingSettingsMapEntry* 
     *         motionSettings+=MotionSettingsMapEntry*
     *     )
     */
    			protected void sequence_PhysicalSettings(ISerializationContext context, PhysicalSettings semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    
    
    /**
     * Contexts:
     *     Expression returns Add
     *     PlusOrMinus returns Add
     *     PlusOrMinus.Add_1_0_0_0 returns Add
     *     PlusOrMinus.Subtract_1_0_1_0 returns Add
     *     MulOrDiv returns Add
     *     MulOrDiv.Multiply_1_0_0_0 returns Add
     *     MulOrDiv.Divide_1_0_1_0 returns Add
     *     Primary returns Add
     *
     * Constraint:
     *     (left=PlusOrMinus_Add_1_0_0_0 right=MulOrDiv)
     */
    			protected void sequence_PlusOrMinus(ISerializationContext context, Add semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient(semanticObject, ExpressionsPackage.Literals.BINARY_EXPRESSION__LEFT) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, ExpressionsPackage.Literals.BINARY_EXPRESSION__LEFT));
        if (transientValues.isValueTransient(semanticObject, ExpressionsPackage.Literals.BINARY_EXPRESSION__RIGHT) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, ExpressionsPackage.Literals.BINARY_EXPRESSION__RIGHT));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
    feeder.accept(grammarAccess.getPlusOrMinusAccess().getAddLeftAction_1_0_0_0(), semanticObject.getLeft());
    feeder.accept(grammarAccess.getPlusOrMinusAccess().getRightMulOrDivParserRuleCall_1_1_0(), semanticObject.getRight());
    feeder.finish();
    }
    
    
    /**
     * Contexts:
     *     Expression returns Subtract
     *     PlusOrMinus returns Subtract
     *     PlusOrMinus.Add_1_0_0_0 returns Subtract
     *     PlusOrMinus.Subtract_1_0_1_0 returns Subtract
     *     MulOrDiv returns Subtract
     *     MulOrDiv.Multiply_1_0_0_0 returns Subtract
     *     MulOrDiv.Divide_1_0_1_0 returns Subtract
     *     Primary returns Subtract
     *
     * Constraint:
     *     (left=PlusOrMinus_Subtract_1_0_1_0 right=MulOrDiv)
     */
    			protected void sequence_PlusOrMinus(ISerializationContext context, Subtract semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient(semanticObject, ExpressionsPackage.Literals.BINARY_EXPRESSION__LEFT) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, ExpressionsPackage.Literals.BINARY_EXPRESSION__LEFT));
        if (transientValues.isValueTransient(semanticObject, ExpressionsPackage.Literals.BINARY_EXPRESSION__RIGHT) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, ExpressionsPackage.Literals.BINARY_EXPRESSION__RIGHT));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
    feeder.accept(grammarAccess.getPlusOrMinusAccess().getSubtractLeftAction_1_0_1_0(), semanticObject.getLeft());
    feeder.accept(grammarAccess.getPlusOrMinusAccess().getRightMulOrDivParserRuleCall_1_1_0(), semanticObject.getRight());
    feeder.finish();
    }
    
    
    /**
     * Contexts:
     *     ProfileSettingsMapEntry returns ProfileSettingsMapEntry
     *
     * Constraint:
     *     (key=[Profile|ID] value=MotionProfileSettings)
     */
    			protected <T extends Map.Entry & EObject> void sequence_ProfileSettingsMapEntry(ISerializationContext context, T semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient((EObject) semanticObject, SettingPackage.Literals.PROFILE_SETTINGS_MAP_ENTRY__KEY) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing((EObject) semanticObject, SettingPackage.Literals.PROFILE_SETTINGS_MAP_ENTRY__KEY));
        if (transientValues.isValueTransient((EObject) semanticObject, SettingPackage.Literals.PROFILE_SETTINGS_MAP_ENTRY__VALUE) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing((EObject) semanticObject, SettingPackage.Literals.PROFILE_SETTINGS_MAP_ENTRY__VALUE));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, (EObject) semanticObject);
    feeder.accept(grammarAccess.getProfileSettingsMapEntryAccess().getKeyProfileIDTerminalRuleCall_0_0_1(), semanticObject.eGet(SettingPackage.Literals.PROFILE_SETTINGS_MAP_ENTRY__KEY, false));
    feeder.accept(grammarAccess.getProfileSettingsMapEntryAccess().getValueMotionProfileSettingsParserRuleCall_1_0(), semanticObject.getValue());
    feeder.finish();
    }
    
    
    /**
     * Contexts:
     *     Settings returns Settings
     *
     * Constraint:
     *     (imports+=Import* declarations+=Declaration* physicalSettings+=PhysicalSettings*)
     */
    			protected void sequence_Settings(ISerializationContext context, Settings semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    
    
    /**
     * Contexts:
     *     TimingSettingsMapEntry returns TimingSettingsMapEntry
     *
     * Constraint:
     *     (key=[ActionType|ID] value=Timing)
     */
    			protected <T extends Map.Entry & EObject> void sequence_TimingSettingsMapEntry(ISerializationContext context, T semanticObject) {
    if (errorAcceptor != null) {
        if (transientValues.isValueTransient((EObject) semanticObject, SettingPackage.Literals.TIMING_SETTINGS_MAP_ENTRY__KEY) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing((EObject) semanticObject, SettingPackage.Literals.TIMING_SETTINGS_MAP_ENTRY__KEY));
        if (transientValues.isValueTransient((EObject) semanticObject, SettingPackage.Literals.TIMING_SETTINGS_MAP_ENTRY__VALUE) == ValueTransient.YES)
            errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing((EObject) semanticObject, SettingPackage.Literals.TIMING_SETTINGS_MAP_ENTRY__VALUE));
    }
    SequenceFeeder feeder = createSequencerFeeder(context, (EObject) semanticObject);
    feeder.accept(grammarAccess.getTimingSettingsMapEntryAccess().getKeyActionTypeIDTerminalRuleCall_0_0_1(), semanticObject.eGet(SettingPackage.Literals.TIMING_SETTINGS_MAP_ENTRY__KEY, false));
    feeder.accept(grammarAccess.getTimingSettingsMapEntryAccess().getValueTimingParserRuleCall_2_0(), semanticObject.getValue());
    feeder.finish();
    }
    
    
    /**
     * Contexts:
     *     Timing returns TriangularDistribution
     *     TriangularDistribution returns TriangularDistribution
     *
     * Constraint:
     *     (minExp=Expression maxExp=Expression modeExp=Expression defaultExp=Expression?)
     */
    			protected void sequence_TriangularDistribution(ISerializationContext context, TriangularDistribution semanticObject) {
    genericSequencer.createSequence(context, semanticObject);
    }
    
    
}
