/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.datasynth.varorder;

import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import org.eclipse.escet.cif.datasynth.varorder.AutoVarOrderer;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;

public class ForceVarOrderer
extends AutoVarOrderer {
    private double[] locations;
    private List<IdxLocPair> idxLocPairs;
    private double[] cogs;
    private int[] edgeCounts;

    @Override
    protected void initializeAlgo() {
        this.locations = new double[this.varCnt];
        this.idxLocPairs = Lists.listc((int)this.varCnt);
        int i = 0;
        while (i < this.varCnt) {
            this.idxLocPairs.add(new IdxLocPair());
            ++i;
        }
        this.cogs = new double[this.edges.length];
        this.edgeCounts = new int[this.varCnt];
        BitSet[] bitSetArray = this.edges;
        int n = this.edges.length;
        int n2 = 0;
        while (n2 < n) {
            BitSet edge = bitSetArray[n2];
            int i2 = 0;
            while (i2 < this.varCnt) {
                if (edge.get(i2)) {
                    int n3 = i2;
                    this.edgeCounts[n3] = this.edgeCounts[n3] + 1;
                }
                ++i2;
            }
            ++n2;
        }
    }

    @Override
    protected void cleanupAlgo() {
        this.locations = null;
        this.idxLocPairs = null;
        this.cogs = null;
        this.edgeCounts = null;
    }

    @Override
    protected void computeOrder() {
        long curTotalSpan;
        if (this.dbgEnabled) {
            OutputProvider.dbg();
            OutputProvider.dbg((String)"  Applying FORCE algorithm:");
        }
        int maxIter = (int)Math.ceil(Math.log(this.varCnt));
        maxIter *= 10;
        if (this.dbgEnabled) {
            OutputProvider.dbg((String)"    Maximum number of iterations: %,d", (Object[])new Object[]{maxIter});
        }
        long bestTotalSpan = curTotalSpan = this.computeTotalSpan(this.newIndices);
        if (this.dbgEnabled) {
            OutputProvider.dbg();
            OutputProvider.dbg((String)"    Total span: %,20d (total) %,20.2f (avg/edge) [before]", (Object[])new Object[]{curTotalSpan, (double)curTotalSpan / (double)this.edges.length});
        }
        int curIter = 0;
        while (curIter < maxIter) {
            BitSet edge;
            int i = 0;
            while (i < this.edges.length) {
                edge = this.edges[i];
                double cog = 0.0;
                int cnt = 0;
                int j = 0;
                while (j < this.varCnt) {
                    if (edge.get(j)) {
                        cog += (double)this.newIndices[j];
                        ++cnt;
                    }
                    ++j;
                }
                this.cogs[i] = cog / (double)cnt;
                ++i;
            }
            Arrays.fill(this.locations, 0.0);
            i = 0;
            while (i < this.edges.length) {
                edge = this.edges[i];
                int j = 0;
                while (j < this.varCnt) {
                    if (edge.get(j)) {
                        int n = j;
                        this.locations[n] = this.locations[n] + this.cogs[i];
                    }
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < this.varCnt) {
                int n = i;
                this.locations[n] = this.locations[n] / (double)this.edgeCounts[i];
                ++i;
            }
            i = 0;
            while (i < this.varCnt) {
                IdxLocPair pair = this.idxLocPairs.get(i);
                pair.idx = i;
                pair.location = this.locations[i];
                ++i;
            }
            Collections.sort(this.idxLocPairs);
            i = 0;
            while (i < this.varCnt) {
                this.newIndices[this.idxLocPairs.get((int)i).idx] = i;
                ++i;
            }
            long newTotalSpan = this.computeTotalSpan(this.newIndices);
            if (this.dbgEnabled) {
                OutputProvider.dbg((String)"    Total span: %,20d (total) %,20.2f (avg/edge) [iteration %,d]", (Object[])new Object[]{newTotalSpan, (double)newTotalSpan / (double)this.edges.length, curIter + 1});
            }
            if (newTotalSpan == curTotalSpan) break;
            if (newTotalSpan < bestTotalSpan) {
                System.arraycopy(this.newIndices, 0, this.bestIndices, 0, this.varCnt);
                bestTotalSpan = newTotalSpan;
            }
            curTotalSpan = newTotalSpan;
            ++curIter;
        }
        if (this.dbgEnabled) {
            OutputProvider.dbg((String)"    Total span: %,20d (total) %,20.2f (avg/edge) [after]", (Object[])new Object[]{bestTotalSpan, (double)bestTotalSpan / (double)this.edges.length});
        }
    }

    private static class IdxLocPair
    implements Comparable<IdxLocPair> {
        public int idx;
        public double location;

        private IdxLocPair() {
        }

        @Override
        public int compareTo(IdxLocPair other) {
            int rslt = Double.compare(this.location, other.location);
            if (rslt != 0) {
                return rslt;
            }
            return Integer.compare(this.idx, other.idx);
        }

        public String toString() {
            return Strings.fmt((String)"(%s, %s)", (Object[])new Object[]{this.idx, this.location});
        }
    }
}

