/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2cif;

import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.escet.cif.cif2cif.CifToCifPreconditionException;
import org.eclipse.escet.cif.cif2cif.CifToCifTransformation;
import org.eclipse.escet.cif.cif2cif.PrintFileIntoDecls;
import org.eclipse.escet.cif.cif2cif.SvgFileIntoDecls;
import org.eclipse.escet.cif.common.CifScopeUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.metamodel.cif.Component;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumDecl;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumLiteral;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class ElimGroups
implements CifToCifTransformation {
    private final List<Group> groups = Lists.list();
    private final List<Automaton> automata = Lists.list();

    @Override
    public void transform(Specification spec) {
        String newName;
        String oldName;
        if (CifScopeUtils.hasCompDefInst((Group)spec)) {
            String msg = "Eliminating groups from a CIF specification with component definitions is currently not supported.";
            throw new CifToCifPreconditionException(msg);
        }
        new SvgFileIntoDecls().transform(spec);
        new PrintFileIntoDecls().transform(spec);
        this.collect((Group)spec);
        Set liftedNames = Sets.set();
        for (Automaton automaton : this.automata) {
            String absName = CifTextUtils.getAbsName((PositionObject)automaton, (boolean)false).replace('.', '_');
            automaton.setName(absName);
            liftedNames.add(absName);
        }
        List liftedDecls = Lists.list();
        for (Group group : this.groups) {
            for (Declaration decl : group.getDeclarations()) {
                liftedDecls.add(decl);
                String absName = CifTextUtils.getAbsName((PositionObject)decl, (boolean)false).replace('.', '_');
                decl.setName(absName);
                liftedNames.add(absName);
            }
        }
        EList components = spec.getComponents();
        components.clear();
        Set specNames = CifScopeUtils.getSymbolNamesForScope((PositionObject)spec, null);
        components.addAll(this.automata);
        EList specInitials = spec.getInitials();
        EList specInvariants = spec.getInvariants();
        EList specMarkeds = spec.getMarkeds();
        EList specEquations = spec.getEquations();
        for (Group group : this.groups) {
            specInitials.addAll(group.getInitials());
            specInvariants.addAll(group.getInvariants());
            specMarkeds.addAll(group.getMarkeds());
            specEquations.addAll(group.getEquations());
        }
        EList specIoDecls = spec.getIoDecls();
        for (Group group : this.groups) {
            specIoDecls.addAll(group.getIoDecls());
        }
        EList specDecls = spec.getDeclarations();
        for (Declaration decl : liftedDecls) {
            specDecls.add(decl);
            if (!(decl instanceof EnumDecl)) continue;
            for (EnumLiteral lit : ((EnumDecl)decl).getLiterals()) {
                liftedNames.add(lit.getName());
            }
        }
        Set usedNames = Sets.copy((Set)specNames);
        for (Automaton automaton : this.automata) {
            if (usedNames.contains(automaton.getName())) {
                oldName = automaton.getName();
                newName = CifScopeUtils.getUniqueName((String)oldName, (Set)usedNames, (Set)liftedNames);
                automaton.setName(newName);
                OutputProvider.warn((String)"Automaton \"%s\" is renamed to \"%s\".", (Object[])new Object[]{oldName, newName});
            }
            usedNames.add(automaton.getName());
        }
        for (Declaration decl : liftedDecls) {
            if (usedNames.contains(decl.getName())) {
                oldName = decl.getName();
                newName = CifScopeUtils.getUniqueName((String)oldName, (Set)usedNames, (Set)liftedNames);
                decl.setName(newName);
                OutputProvider.warn((String)"Declaration \"%s\" is renamed to \"%s\".", (Object[])new Object[]{oldName, newName});
            }
            usedNames.add(decl.getName());
            if (!(decl instanceof EnumDecl)) continue;
            for (EnumLiteral lit : ((EnumDecl)decl).getLiterals()) {
                if (usedNames.contains(lit.getName())) {
                    String oldName2 = lit.getName();
                    String newName2 = CifScopeUtils.getUniqueName((String)oldName2, (Set)usedNames, (Set)liftedNames);
                    lit.setName(newName2);
                    OutputProvider.warn((String)"Enumeration literal \"%s\" is renamed to \"%s\". This may have changed the semantics of the specification. It may also cause the specification to be become invalid. It is highly recommended to avoid this renaming!", (Object[])new Object[]{oldName2, newName2});
                }
                usedNames.add(lit.getName());
            }
        }
    }

    private void collect(Group group) {
        if (!(group instanceof Specification)) {
            this.groups.add(group);
        }
        for (Component component : group.getComponents()) {
            if (component instanceof Automaton) {
                this.automata.add((Automaton)component);
                continue;
            }
            Assert.check((boolean)(component instanceof Group));
            Group child = (Group)component;
            this.collect(child);
        }
    }
}

