/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.options;

import org.eclipse.escet.cif.simulator.options.FrameRateOption;
import org.eclipse.escet.common.app.framework.options.DoubleOption;
import org.eclipse.escet.common.app.framework.options.Options;

public class SimulationSpeedOption
extends DoubleOption {
    public SimulationSpeedOption() {
        super("Simulation speed", "Controls the simulation speed. Specify any positive real value SPEED to use as scaling factor. A scaling factor of 1.0 interprets model time as seconds, 2.0 is twice as fast (1 unit of model time takes 0.5 seconds), etc. Specify \"auto\" (default) for a simulation speed of 1.0 if a frame rate is given, and for infinite speed (as fast as possible, which means that time transitions take no time), if no frame rate is given.", null, "speed", "SPEED", null, Double.valueOf(0.0), null, true, "Controls the simulation speed. A scaling factor of 1.0 interprets model time as seconds, 2.0 is twice as fast (1 unit of model time takes 0.5 seconds), etc.", "Scaling factor:", true, Double.valueOf(1.0), "auto", "Automatic (1.0 if frame rate is given, infinite otherwise)", "Specific speed (use a scaling factor)");
    }

    public static Double getSimSpeed() {
        Double rslt = (Double)Options.get(SimulationSpeedOption.class);
        if (rslt == null && Options.get(FrameRateOption.class) != null) {
            return 1.0;
        }
        return rslt;
    }

    public void verifyValue(Double value) {
        if (value == null) {
            return;
        }
        SimulationSpeedOption.checkValue((value > 0.0 ? 1 : 0) != 0, (String)(value + " <= 0"));
    }
}

