/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.output.plotviz;

import java.util.List;
import java.util.function.Consumer;
import org.eclipse.escet.cif.simulator.input.ChosenTargetTime;
import org.eclipse.escet.cif.simulator.options.CifSpecOption;
import org.eclipse.escet.cif.simulator.options.FrameRateOption;
import org.eclipse.escet.cif.simulator.output.NullSimulatorOutputComponent;
import org.eclipse.escet.cif.simulator.output.plotviz.PlotVisualizationFiltersOption;
import org.eclipse.escet.cif.simulator.output.plotviz.PlotVisualizationMode;
import org.eclipse.escet.cif.simulator.output.plotviz.PlotVisualizationModeOption;
import org.eclipse.escet.cif.simulator.output.plotviz.PlotVisualizationOption;
import org.eclipse.escet.cif.simulator.output.plotviz.PlotVisualizationRangeOption;
import org.eclipse.escet.cif.simulator.output.plotviz.PlotVisualizer;
import org.eclipse.escet.cif.simulator.output.plotviz.PlotVisualizerData;
import org.eclipse.escet.cif.simulator.output.plotviz.PlotVisualizerDataSeries;
import org.eclipse.escet.cif.simulator.output.plotviz.PlotVisualizerRange;
import org.eclipse.escet.cif.simulator.runtime.SimulationResult;
import org.eclipse.escet.cif.simulator.runtime.model.RuntimeState;
import org.eclipse.escet.cif.simulator.runtime.transitions.EventTransition;
import org.eclipse.escet.cif.simulator.runtime.transitions.HistoryTransition;
import org.eclipse.escet.cif.simulator.runtime.transitions.TimeTransition;
import org.eclipse.escet.cif.simulator.runtime.transitions.Transition;
import org.eclipse.escet.common.app.framework.options.OptionCategory;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.eclipse.ui.ControlEditor;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;

public class PlotVisualizerOutputComponent
extends NullSimulatorOutputComponent {
    private final boolean realTime = FrameRateOption.isRealTimeEnabled();
    private final PlotVisualizationMode mode = PlotVisualizationModeOption.getPlotVizMode();
    private PlotVisualizerData data;
    private PlotVisualizer visualizer;

    public PlotVisualizerOutputComponent(String filtersTxt) {
        this.data = new PlotVisualizerData(filtersTxt);
        if (this.mode == PlotVisualizationMode.LIVE) {
            this.showVisualizer();
        }
    }

    @Override
    public void initialState(RuntimeState state) {
        this.data.initMeta(state);
        if (this.mode == PlotVisualizationMode.LIVE) {
            this.doVisualizer(v -> {
                v.initVarDatas(this.data.metas);
                this.addState(state, (PlotVisualizer)((Object)v));
                this.setRange((PlotVisualizer)((Object)v));
            });
        } else {
            this.data.initVarDatas();
            this.addState(state, null);
        }
    }

    @Override
    public void transitionChosen(RuntimeState sourceState, Transition<?> transition, ChosenTargetTime chosenTargetTime) {
        if (!(transition instanceof EventTransition)) {
            if (transition instanceof TimeTransition) {
                if (this.mode == PlotVisualizationMode.LIVE) {
                    this.doVisualizer(v -> {
                        this.addState(sourceState, (PlotVisualizer)((Object)v));
                        this.setRange((PlotVisualizer)((Object)v));
                    });
                } else {
                    this.addState(sourceState, null);
                }
            } else if (!(transition instanceof HistoryTransition)) {
                throw new RuntimeException("Unknown transition: " + transition);
            }
        }
    }

    @Override
    public void intermediateTrajectoryState(RuntimeState state) {
        Assert.check((boolean)this.realTime);
        if (this.mode == PlotVisualizationMode.LIVE) {
            this.doVisualizer(v -> {
                this.addState(state, (PlotVisualizer)((Object)v));
                this.setRange((PlotVisualizer)((Object)v));
            });
        } else {
            this.addState(state, null);
        }
    }

    @Override
    public void transitionTaken(RuntimeState sourceState, Transition<?> transition, RuntimeState targetState, Boolean interrupted) {
        if (!(transition instanceof EventTransition)) {
            if (transition instanceof TimeTransition) {
                Consumer<PlotVisualizer> consumer = v -> this.transitionTakenTime((PlotVisualizer)((Object)v), (TimeTransition)transition, targetState);
                if (this.mode == PlotVisualizationMode.LIVE) {
                    this.doVisualizer(consumer);
                } else {
                    consumer.accept(null);
                }
            } else if (transition instanceof HistoryTransition) {
                double time = ((RuntimeState)transition.getTargetState(null, null)).getTime();
                if (this.mode == PlotVisualizationMode.LIVE) {
                    this.doVisualizer(v -> {
                        this.removeStates(time, (PlotVisualizer)((Object)v));
                        this.setRange((PlotVisualizer)((Object)v));
                    });
                } else {
                    this.removeStates(time, null);
                }
            } else {
                throw new RuntimeException("Unknown transition: " + transition);
            }
        }
    }

    private void transitionTakenTime(PlotVisualizer v, TimeTransition<?> timeTrans, RuntimeState targetState) {
        if (!this.realTime) {
            double targetTime = targetState.getTime();
            int count = timeTrans.getTrajectories().getCount();
            int i = 1;
            while (i < count - 1) {
                Object state = timeTrans.getTargetStateForIndex(i);
                if (((RuntimeState)state).getTime() >= targetTime) break;
                this.addState((RuntimeState)state, v);
                ++i;
            }
        }
        this.addState(targetState, v);
        if (v != null) {
            this.setRange(v);
        }
    }

    @Override
    public void simulationEnded(SimulationResult rslt, RuntimeState state) {
        if (this.mode == PlotVisualizationMode.LIVE) {
            this.doVisualizer(v -> this.setRange((PlotVisualizer)((Object)v)));
        } else {
            this.showVisualizer();
            this.doVisualizer(v -> {
                v.initVarDatas(this.data.metas);
                this.moveDataToVisualizer((PlotVisualizer)((Object)v));
                this.setRange((PlotVisualizer)((Object)v));
            });
        }
    }

    private void showVisualizer() {
        if (this.testMode) {
            return;
        }
        String path = CifSpecOption.getCifSpecPath();
        this.visualizer = (PlotVisualizer)ControlEditor.show((String)path, PlotVisualizer.class, (String)"show the plot visualizer");
    }

    private void doVisualizer(Consumer<PlotVisualizer> consumer) {
        if (this.testMode) {
            return;
        }
        PlotVisualizer viz = this.visualizer;
        if (viz == null || !viz.isAvailable()) {
            return;
        }
        try {
            consumer.accept(viz);
        }
        finally {
            viz.postUpdate();
        }
    }

    private void addState(RuntimeState state, PlotVisualizer viz) {
        if (this.mode == PlotVisualizationMode.LIVE) {
            this.data.add(state, this.data.metas, viz.varDatas);
        } else {
            this.data.add(state, this.data.metas, this.data.varDatas);
        }
    }

    private void removeStates(double time, PlotVisualizer viz) {
        if (this.mode == PlotVisualizationMode.LIVE) {
            this.data.remove(time, viz.varDatas);
        } else {
            this.data.remove(time, this.data.varDatas);
        }
    }

    private void moveDataToVisualizer(PlotVisualizer v) {
        Assert.check((this.mode == PlotVisualizationMode.POSTPONED ? 1 : 0) != 0);
        v.varDatas = this.data.varDatas;
        this.data.varDatas = null;
    }

    private void setRange(PlotVisualizer v) {
        if (v.varDatas == null) {
            return;
        }
        if (v.varDatas.isEmpty()) {
            return;
        }
        PlotVisualizerDataSeries series0 = (PlotVisualizerDataSeries)Lists.first(v.varDatas);
        if (series0.points.isEmpty()) {
            return;
        }
        double t0 = series0.points.getFirst().x;
        double t1 = series0.points.getLast().x;
        if (this.data.range != null) {
            double t = t1 - this.data.range;
            if (t < 0.0) {
                t = 0.0;
            }
            t0 = Math.max(t0, t);
        }
        v.rangeX = new PlotVisualizerRange(t0, t1);
    }

    public void cleanup() {
        if (this.visualizer != null) {
            this.visualizer = null;
        }
    }

    @Override
    public boolean hasVisualInterface() {
        return this.visualizer != null && this.visualizer.isAvailable();
    }

    public static OptionCategory getOptions() {
        List subCats = Lists.list();
        List opts = Lists.list();
        opts.add(Options.getInstance(PlotVisualizationOption.class));
        opts.add(Options.getInstance(PlotVisualizationModeOption.class));
        opts.add(Options.getInstance(PlotVisualizationFiltersOption.class));
        opts.add(Options.getInstance(PlotVisualizationRangeOption.class));
        return new OptionCategory("Plot visualization", "Plot visualization options.", subCats, opts);
    }
}

