/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.runtime;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.escet.cif.common.CifExtFuncUtils;
import org.eclipse.escet.cif.simulator.CifSimulatorContext;
import org.eclipse.escet.cif.simulator.runtime.CifSimulatorException;
import org.eclipse.escet.common.app.framework.AppEnv;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.app.framework.io.AppStream;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Strings;

public class ExtFuncs {
    private static final int TERMINATE_POLL_TIME = 100;

    private ExtFuncs() {
    }

    public static Method loadJavaMethod(String cifFuncName, String className, String methodName, String classPath, String workingDir, Class<?>[] paramTypes, Class<?> expReturnType) {
        try {
            String msg;
            Method extMethod;
            Class<?> extClass;
            ClassLoader classLoader = ClassLoader.getSystemClassLoader();
            if (classPath != null) {
                String[] classPathParts = CifExtFuncUtils.splitJavaClassPathEntries((String)classPath);
                URL[] classPathUrls = new URL[classPathParts.length];
                int i = 0;
                while (i < classPathParts.length) {
                    String classPathPart = classPathParts[i];
                    classPathPart = Paths.resolve((String)classPathPart, (String)workingDir);
                    File classPartFile = new File(classPathPart);
                    Assert.check((boolean)classPartFile.isAbsolute());
                    try {
                        classPathUrls[i] = classPartFile.toURI().toURL();
                    }
                    catch (MalformedURLException e) {
                        throw new RuntimeException(e);
                    }
                    if (!classPartFile.exists()) {
                        String msg2 = Strings.fmt((String)"Invalid class path entry \"%s\": the path of the entry does not exist.", (Object[])new Object[]{classPathPart});
                        throw new CifSimulatorException(msg2);
                    }
                    ++i;
                }
                classLoader = new URLClassLoader(classPathUrls, classLoader);
            }
            try {
                extClass = classLoader.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                String msg3 = Strings.fmt((String)"Class \"%s\" could not be found.", (Object[])new Object[]{className});
                throw new CifSimulatorException(msg3, e);
            }
            try {
                extMethod = extClass.getDeclaredMethod(methodName, paramTypes);
            }
            catch (NoSuchMethodException e) {
                msg = Strings.fmt((String)"Class \"%s\" has no method \"%s\", or the arguments of the method are incompatible.", (Object[])new Object[]{className, methodName});
                throw new CifSimulatorException(msg, e);
            }
            if (!Modifier.isStatic(extMethod.getModifiers())) {
                String msg4 = Strings.fmt((String)"Method \"%s\" of class \"%s\" is not static.", (Object[])new Object[]{methodName, className});
                throw new CifSimulatorException(msg4);
            }
            Class<Object> actualReturnType = extMethod.getReturnType();
            if (actualReturnType == Boolean.TYPE) {
                actualReturnType = Boolean.class;
            } else if (actualReturnType == Integer.TYPE) {
                actualReturnType = Integer.class;
            } else if (actualReturnType == Double.TYPE) {
                actualReturnType = Double.class;
            }
            if (!expReturnType.isAssignableFrom(actualReturnType)) {
                msg = Strings.fmt((String)"Method \"%s\" has a \"%s\" return type, while a \"%s\" type is expected.", (Object[])new Object[]{extMethod.toGenericString(), actualReturnType.getName(), expReturnType.getName()});
                throw new CifSimulatorException(msg);
            }
            extMethod.setAccessible(true);
            return extMethod;
        }
        catch (CifSimulatorException e) {
            String msg = Strings.fmt((String)"Failed to load external user-defined function \"%s\".", (Object[])new Object[]{cifFuncName});
            throw new CifSimulatorException(msg, e);
        }
    }

    public static Object invokeJavaMethodAsync(final CifSimulatorContext ctxt, final Method method, final Object ... args) {
        Thread[] threads;
        if (!ctxt.extFuncAsync) {
            return ExtFuncs.invokeJavaMethodSync(method, args);
        }
        final Object[] rslt = new Object[1];
        final Throwable[] ex = new Throwable[1];
        final AtomicBoolean done = new AtomicBoolean(false);
        boolean INVOKE = false;
        boolean OBSERVER = true;
        threads = new Thread[]{new Thread(new Runnable(){

            /*
             * Loose catch block
             */
            @Override
            public void run() {
                block9: {
                    try {
                        try {
                            rslt[0] = ExtFuncs.invokeJavaMethodInternal(method, args);
                        }
                        catch (ThreadDeath threadDeath) {
                            done.set(true);
                            threads[1].interrupt();
                        }
                        catch (InvocationTargetException e) {
                            ex[0] = e;
                            done.set(true);
                            threads[1].interrupt();
                        }
                        catch (ExceptionInInitializerError e) {
                            ex[0] = e;
                            done.set(true);
                            threads[1].interrupt();
                            break block9;
                            {
                                catch (Throwable throwable) {
                                    throw throwable;
                                }
                            }
                        }
                    }
                    finally {
                        done.set(true);
                        threads[1].interrupt();
                    }
                }
            }
        }), new Thread(new Runnable(){

            @Override
            public void run() {
                while (!done.get()) {
                    if (ctxt.appEnvData.isTerminationRequested()) {
                        threads[0].stop();
                        return;
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
                return;
            }
        })};
        threads[0].setName("CifExtFuncInvoke: " + method.toString());
        threads[0].start();
        threads[1].setName("CifExtFuncObserver: " + method.toString());
        threads[1].start();
        try {
            threads[0].join();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        try {
            threads[1].join();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        ctxt.checkTermination();
        if (ex[0] == null) {
            return rslt[0];
        }
        ExtFuncs.reportJavaMethodInvokeError(ex[0]);
        return null;
    }

    public static Object invokeJavaMethodSync(Method method, Object ... args) {
        try {
            return ExtFuncs.invokeJavaMethodInternal(method, args);
        }
        catch (InvocationTargetException e) {
            ExtFuncs.reportJavaMethodInvokeError(e);
            return null;
        }
        catch (ExceptionInInitializerError e) {
            ExtFuncs.reportJavaMethodInvokeError(e);
            return null;
        }
    }

    protected static Object invokeJavaMethodInternal(Method method, Object ... args) throws InvocationTargetException {
        try {
            return method.invoke(null, args);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    protected static void reportJavaMethodInvokeError(Throwable ex) {
        Assert.notNull((Object)ex);
        AppStream errStream = AppEnv.getStreams().err;
        errStream.println("ERROR: Java method execution failed:");
        errStream.printStackTrace(ex);
        errStream.println();
        errStream.flush();
        String msg = "Java method execution failed.";
        throw new CifSimulatorException(msg, ex);
    }

    public static void checkJavaNullReturn(Object value) {
        if (value == null) {
            String msg = "The return value of the external Java function contains a \"null\" value.";
            throw new CifSimulatorException(msg);
        }
    }

    public static void checkJavaDoubleReturn(double value) {
        if (Double.isNaN(value)) {
            String msg = "The return value of the external Java function contains a NaN value.";
            throw new CifSimulatorException(msg);
        }
        if (value == Double.NEGATIVE_INFINITY) {
            String msg = "The return value of the external Java function contains a -inf value.";
            throw new CifSimulatorException(msg);
        }
        if (value == Double.POSITIVE_INFINITY) {
            String msg = "The return value of the external Java function contains a +inf value.";
            throw new CifSimulatorException(msg);
        }
    }

    public static void checkJavaRetTypeFailed(Object value, Class<?> expected) {
        String msg = Strings.fmt((String)"The return value of the external Java function contains a value of type \"%s\", while a value of type \"%s\" was expected.", (Object[])new Object[]{value.getClass().getName(), expected.getName()});
        throw new CifSimulatorException(msg);
    }

    public static void checkJavaIntRangeFailed(int value, int lower, int upper) {
        String msg = Strings.fmt((String)"The return value of the external Java function contains integer value %d, while a value of type \"int[%d .. %d]\" was expected.", (Object[])new Object[]{value, lower, upper});
        throw new CifSimulatorException(msg);
    }

    public static void checkJavaListRangeFailed(List<?> value, int lower, int upper) {
        String typeRange = lower == upper ? Strings.str((Object)lower) : Strings.fmt((String)"%d..%d", (Object[])new Object[]{lower, upper});
        String msg = Strings.fmt((String)"The return value of the external Java function contains a list with %d element(s), while a list of type \"list[%s]\" was expected.", (Object[])new Object[]{value.size(), typeRange});
        throw new CifSimulatorException(msg);
    }
}

