/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2mcrl2.tree;

import java.util.Map;
import java.util.Set;
import org.eclipse.escet.cif.cif2mcrl2.NameMaps;
import org.eclipse.escet.cif.cif2mcrl2.storage.EventVarUsage;
import org.eclipse.escet.cif.cif2mcrl2.storage.VarUsage;
import org.eclipse.escet.cif.cif2mcrl2.storage.VariableData;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.common.box.Box;
import org.eclipse.escet.common.box.GridBox;
import org.eclipse.escet.common.box.HBox;
import org.eclipse.escet.common.box.StreamCodeBox;
import org.eclipse.escet.common.box.VBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public abstract class ProcessNode {
    public final String name;
    public Set<VariableData> availProcessVars = null;
    public Map<Event, EventVarUsage> eventVarUse = null;
    public Set<VariableData> valueVars = null;

    public ProcessNode(String name) {
        this.name = name;
    }

    protected String getCifName() {
        return null;
    }

    public abstract void deriveActions(Set<VariableData> var1);

    public abstract void addDefinitions(NameMaps var1, Set<VariableData> var2, VBox var3);

    public abstract void addInstantiations(NameMaps var1, Set<VariableData> var2, VBox var3);

    public void dumpActions(StreamCodeBox code) {
        code.add("===============================================================");
        String cifName = this.getCifName();
        cifName = cifName == null ? "" : " (" + cifName + ")";
        code.add(Strings.fmt((String)"Node %s%s", (Object[])new Object[]{this.name, cifName}));
        if (!this.availProcessVars.isEmpty()) {
            code.add();
            code.add("Available variable processes:");
            code.indent();
            for (VariableData variableData : this.availProcessVars) {
                code.add(variableData.name);
            }
            code.dedent();
        }
        if (!this.eventVarUse.isEmpty()) {
            code.add();
            code.add("Variable use by behavior processes ordered by event:");
            code.indent();
            for (Map.Entry entry : this.eventVarUse.entrySet()) {
                code.add(String.valueOf(CifTextUtils.getAbsName((PositionObject)((PositionObject)entry.getKey()))) + ":");
                code.indent();
                Map<VariableData, VarUsage> values = ((EventVarUsage)entry.getValue()).varUses;
                if (values.isEmpty()) {
                    code.add("No variables from variables processes accessed.");
                } else {
                    GridBox b = new GridBox(values.entrySet().size(), 3, 0, 2);
                    int i = 0;
                    for (Map.Entry<VariableData, VarUsage> usages : values.entrySet()) {
                        b.set(i, 0, usages.getKey().name);
                        VarUsage vu = usages.getValue();
                        HBox c = new HBox(new Object[]{"read:", vu.readAccess.toString()});
                        b.set(i, 1, (Box)c);
                        c = new HBox(new Object[]{"write:", vu.writeAccess.toString()});
                        b.set(i, 2, (Box)c);
                        ++i;
                    }
                    Assert.check((i == values.entrySet().size() ? 1 : 0) != 0);
                    code.add((Box)b);
                }
                code.dedent();
            }
            code.dedent();
        }
    }
}

