/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.style;

import java.awt.Color;
import java.awt.Font;
import java.awt.Stroke;
import org.knowm.xchart.style.Styler;
import org.knowm.xchart.style.Theme;

public class RadarStyler
extends Styler {
    private boolean isCircular;
    private double startAngleInDegrees;
    private boolean plotGridLinesVisible;
    private Color plotGridLinesColor;
    private Stroke plotGridLinesStroke;
    private boolean axisTicksMarksVisible;
    private Color axisTickMarksColor;
    private Stroke axisTickMarksStroke;
    private int axisTickMarksCount = 5;
    private boolean axisTitleVisible;
    private Font axisTitleFont;
    private int axisTitlePadding;
    private int markerSize;
    private boolean seriesFilled = true;

    public RadarStyler() {
        this.setAllStyles();
    }

    @Override
    void setAllStyles() {
        super.setAllStyles();
        this.isCircular = this.theme.isCircular();
        this.startAngleInDegrees = this.theme.getStartAngleInDegrees();
        this.hasAnnotations = true;
        this.markerSize = this.theme.getMarkerSize();
        this.plotGridLinesVisible = this.theme.isPlotGridLinesVisible();
        this.plotGridLinesColor = this.theme.getPlotGridLinesColor();
        this.plotGridLinesStroke = this.theme.getPlotGridLinesStroke();
        this.axisTickMarksColor = this.theme.getAxisTickMarksColor();
        this.axisTickMarksStroke = this.theme.getAxisTickMarksStroke();
        this.axisTicksMarksVisible = this.theme.isAxisTicksMarksVisible();
        this.axisTitleVisible = this.theme.isXAxisTitleVisible() || this.theme.isYAxisTitleVisible();
        this.axisTitleFont = this.theme.getAxisTitleFont();
        this.axisTitlePadding = this.theme.getAxisTitlePadding();
    }

    public boolean isCircular() {
        return this.isCircular;
    }

    public RadarStyler setCircular(boolean isCircular) {
        this.isCircular = isCircular;
        return this;
    }

    public double getStartAngleInDegrees() {
        return this.startAngleInDegrees;
    }

    public RadarStyler setStartAngleInDegrees(double startAngleInDegrees) {
        this.startAngleInDegrees = startAngleInDegrees;
        return this;
    }

    public RadarStyler setTheme(Theme theme) {
        this.theme = theme;
        this.setAllStyles();
        return this;
    }

    public int getMarkerSize() {
        return this.markerSize;
    }

    public RadarStyler setMarkerSize(int markerSize) {
        this.markerSize = markerSize;
        return this;
    }

    public boolean isPlotGridLinesVisible() {
        return this.plotGridLinesVisible;
    }

    public void setPlotGridLinesVisible(boolean plotGridLinesVisible) {
        this.plotGridLinesVisible = plotGridLinesVisible;
    }

    public Color getPlotGridLinesColor() {
        return this.plotGridLinesColor;
    }

    public void setPlotGridLinesColor(Color plotGridLinesColor) {
        this.plotGridLinesColor = plotGridLinesColor;
    }

    public Stroke getPlotGridLinesStroke() {
        return this.plotGridLinesStroke;
    }

    public void setPlotGridLinesStroke(Stroke plotGridLinesStroke) {
        this.plotGridLinesStroke = plotGridLinesStroke;
    }

    public boolean isAxisTicksMarksVisible() {
        return this.axisTicksMarksVisible;
    }

    public void setAxisTicksMarksVisible(boolean axisTicksMarksVisible) {
        this.axisTicksMarksVisible = axisTicksMarksVisible;
    }

    public Color getAxisTickMarksColor() {
        return this.axisTickMarksColor;
    }

    public void setAxisTickMarksColor(Color axisTickMarksColor) {
        this.axisTickMarksColor = axisTickMarksColor;
    }

    public Stroke getAxisTickMarksStroke() {
        return this.axisTickMarksStroke;
    }

    public void setAxisTickMarksStroke(Stroke axisTickMarksStroke) {
        this.axisTickMarksStroke = axisTickMarksStroke;
    }

    public boolean isAxisTitleVisible() {
        return this.axisTitleVisible;
    }

    public void setAxisTitleVisible(boolean axisTitleVisible) {
        this.axisTitleVisible = axisTitleVisible;
    }

    public Font getAxisTitleFont() {
        return this.axisTitleFont;
    }

    public void setAxisTitleFont(Font axisTitleFont) {
        this.axisTitleFont = axisTitleFont;
    }

    public int getAxisTitlePadding() {
        return this.axisTitlePadding;
    }

    public void setAxisTitlePadding(int axisTitlePadding) {
        this.axisTitlePadding = axisTitlePadding;
    }

    public int getAxisTickMarksCount() {
        return this.axisTickMarksCount;
    }

    public void setAxisTickMarksCount(int axisTickMarksCount) {
        this.axisTickMarksCount = axisTickMarksCount;
    }

    public boolean isSeriesFilled() {
        return this.seriesFilled;
    }

    public void setSeriesFilled(boolean seriesFilled) {
        this.seriesFilled = seriesFilled;
    }
}

