/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.server;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.lsp4j.DidChangeWorkspaceFoldersParams;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.eclipse.lsp4j.WorkspaceFolder;
import org.eclipse.lsp4j.WorkspaceFoldersChangeEvent;
import org.eclipse.lsp4j.jsonrpc.ResponseErrorException;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseError;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseErrorCode;
import org.eclipse.xtext.ide.server.BuildManager;
import org.eclipse.xtext.ide.server.Document;
import org.eclipse.xtext.ide.server.ILanguageServerAccess;
import org.eclipse.xtext.ide.server.IMultiRootWorkspaceConfigFactory;
import org.eclipse.xtext.ide.server.IProjectDescriptionFactory;
import org.eclipse.xtext.ide.server.ProjectManager;
import org.eclipse.xtext.ide.server.UriExtensions;
import org.eclipse.xtext.resource.IExternalContentSupport;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.resource.impl.ChunkedResourceDescriptions;
import org.eclipse.xtext.resource.impl.ProjectDescription;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsData;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.workspace.IProjectConfig;
import org.eclipse.xtext.workspace.IWorkspaceConfig;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class WorkspaceManager {
    private static final Logger LOG = Logger.getLogger(WorkspaceManager.class);
    @Inject
    private Provider<ProjectManager> projectManagerProvider;
    @Inject
    private IMultiRootWorkspaceConfigFactory workspaceConfigFactory;
    @Inject
    private IProjectDescriptionFactory projectDescriptionFactory;
    @Inject
    private UriExtensions uriExtensions;
    private BuildManager buildManager;
    private List<WorkspaceFolder> workspaceFolders = Collections.emptyList();
    private Procedures.Procedure2<? super URI, ? super Iterable<Issue>> issueAcceptor;
    private IWorkspaceConfig workspaceConfig;
    private final Map<String, ProjectManager> projectName2ProjectManager = new HashMap<String, ProjectManager>();
    private final List<ILanguageServerAccess.IBuildListener> buildListeners = new ArrayList<ILanguageServerAccess.IBuildListener>();
    private final Map<String, ResourceDescriptionsData> fullIndex = new HashMap<String, ResourceDescriptionsData>();
    private final Map<URI, Document> openDocuments = new HashMap<URI, Document>();
    private final IExternalContentSupport.IExternalContentProvider openedDocumentsContentProvider = new IExternalContentSupport.IExternalContentProvider(){

        public IExternalContentSupport.IExternalContentProvider getActualContentProvider() {
            return this;
        }

        public String getContent(URI uri) {
            Document document = (Document)WorkspaceManager.this.openDocuments.get(uri);
            if (document != null) {
                return document.getContents();
            }
            return null;
        }

        public boolean hasContent(URI uri) {
            return WorkspaceManager.this.isDocumentOpen(uri);
        }
    };

    public void addBuildListener(ILanguageServerAccess.IBuildListener listener) {
        this.buildListeners.add(listener);
    }

    public void removeBuildListener(ILanguageServerAccess.IBuildListener listener) {
        this.buildListeners.remove(listener);
    }

    @Inject
    public void setBuildManager(BuildManager buildManager) {
        buildManager.setWorkspaceManager(this);
        this.buildManager = buildManager;
    }

    public void initialize(URI baseDir, Procedures.Procedure2<? super URI, ? super Iterable<Issue>> issueAcceptor, CancelIndicator cancelIndicator) {
        WorkspaceFolder workspaceFolder = new WorkspaceFolder(this.uriExtensions.toUriString(baseDir), "");
        this.initialize(Collections.singletonList(workspaceFolder), issueAcceptor, cancelIndicator);
    }

    public void initialize(List<WorkspaceFolder> workspaceFolders, Procedures.Procedure2<? super URI, ? super Iterable<Issue>> issueAcceptor, CancelIndicator cancelIndicator) {
        this.workspaceFolders = new ArrayList<WorkspaceFolder>(workspaceFolders);
        this.issueAcceptor = issueAcceptor;
        this.refreshWorkspaceConfig(cancelIndicator);
    }

    public boolean isSupportsWorkspaceFolders() {
        return true;
    }

    protected List<WorkspaceFolder> getWorkspaceFolders() {
        return this.workspaceFolders;
    }

    public void didChangeWorkspaceFolders(DidChangeWorkspaceFoldersParams params, CancelIndicator cancelIndicator) {
        WorkspaceFoldersChangeEvent event = params.getEvent();
        HashMap uri2workspaceFolder = new HashMap();
        this.workspaceFolders.forEach(it -> uri2workspaceFolder.put(it.getUri(), it));
        event.getRemoved().forEach(it -> {
            WorkspaceFolder cfr_ignored_0 = (WorkspaceFolder)uri2workspaceFolder.remove(it.getUri());
        });
        event.getAdded().forEach(it -> {
            if (!uri2workspaceFolder.containsKey(it.getUri())) {
                uri2workspaceFolder.put(it.getUri(), it);
            }
        });
        this.workspaceFolders = new ArrayList(uri2workspaceFolder.values());
        this.refreshWorkspaceConfig(cancelIndicator);
    }

    protected IWorkspaceConfig createWorkspaceConfig() {
        return this.workspaceConfigFactory.getWorkspaceConfig(this.workspaceFolders);
    }

    protected void refreshWorkspaceConfig(CancelIndicator cancelIndicator) {
        ProjectManager projectManager;
        IWorkspaceConfig newWorkspaceConfig = this.createWorkspaceConfig();
        this.setWorkspaceConfig(newWorkspaceConfig);
        ArrayList<ProjectDescription> newProjects = new ArrayList<ProjectDescription>();
        Set<String> projectNames = this.projectName2ProjectManager.keySet();
        HashSet<String> remainingProjectNames = new HashSet<String>(projectNames);
        for (IProjectConfig projectConfig : this.getWorkspaceConfig().getProjects()) {
            if (this.projectName2ProjectManager.containsKey(projectConfig.getName())) {
                remainingProjectNames.remove(projectConfig.getName());
                continue;
            }
            projectManager = (ProjectManager)this.projectManagerProvider.get();
            ProjectDescription projectDescription = this.projectDescriptionFactory.getProjectDescription(projectConfig);
            projectManager.initialize(projectDescription, projectConfig, this.issueAcceptor, this.openedDocumentsContentProvider, (Provider<Map<String, ResourceDescriptionsData>>)((Provider)() -> this.fullIndex), cancelIndicator);
            this.projectName2ProjectManager.put(projectDescription.getName(), projectManager);
            newProjects.add(projectDescription);
        }
        for (String deletedProject : remainingProjectNames) {
            projectManager = this.projectName2ProjectManager.remove(deletedProject);
            projectManager.aboutToRemoveFromWorkspace();
            this.fullIndex.remove(deletedProject);
        }
        this.afterBuild(this.buildManager.doInitialBuild(newProjects, cancelIndicator));
    }

    protected IWorkspaceConfig getWorkspaceConfig() throws ResponseErrorException {
        if (this.workspaceConfig == null) {
            ResponseError error = new ResponseError(ResponseErrorCode.serverNotInitialized, "Workspace has not been initialized yet.", null);
            throw new ResponseErrorException(error);
        }
        return this.workspaceConfig;
    }

    protected void setWorkspaceConfig(IWorkspaceConfig workspaceConfig) {
        this.workspaceConfig = workspaceConfig;
    }

    protected void afterBuild(List<IResourceDescription.Delta> deltas) {
        for (ILanguageServerAccess.IBuildListener listener : this.buildListeners) {
            listener.afterBuild(deltas);
        }
    }

    public BuildManager.Buildable didChangeFiles(List<URI> dirtyFiles, List<URI> deletedFiles) {
        BuildManager.Buildable buildable = this.buildManager.submit(dirtyFiles, deletedFiles);
        return cancelIndicator -> {
            List<IResourceDescription.Delta> deltas = buildable.build(cancelIndicator);
            this.afterBuild(deltas);
            return deltas;
        };
    }

    public List<IResourceDescription.Delta> doBuild(List<URI> dirtyFiles, List<URI> deletedFiles, CancelIndicator cancelIndicator) {
        return this.didChangeFiles(dirtyFiles, deletedFiles).build(cancelIndicator);
    }

    public IResourceDescriptions getIndex() {
        return new ChunkedResourceDescriptions(this.fullIndex);
    }

    public URI getProjectBaseDir(URI uri) {
        IProjectConfig projectConfig = this.getProjectConfig(uri);
        if (projectConfig != null) {
            return projectConfig.getPath();
        }
        return null;
    }

    public ProjectManager getProjectManager(URI uri) {
        IProjectConfig projectConfig = this.getProjectConfig(uri);
        String name = null;
        if (projectConfig != null) {
            name = projectConfig.getName();
        }
        return this.getProjectManager(name);
    }

    protected IProjectConfig getProjectConfig(URI uri) {
        return this.getWorkspaceConfig().findProjectContaining(uri);
    }

    public ProjectManager getProjectManager(String projectName) {
        return this.projectName2ProjectManager.get(projectName);
    }

    public List<ProjectManager> getProjectManagers() {
        return ImmutableList.copyOf(this.projectName2ProjectManager.values());
    }

    public BuildManager.Buildable didChangeTextDocumentContent(URI uri, Integer version, Iterable<TextDocumentContentChangeEvent> changes) {
        Document contents = this.openDocuments.get(uri);
        if (contents == null) {
            LOG.error((Object)("The document " + uri + " has not been opened."));
            return BuildManager.Buildable.NO_BUILD;
        }
        this.openDocuments.put(uri, contents.applyTextDocumentChanges(changes));
        return this.didChangeFiles((List<URI>)ImmutableList.of((Object)uri), Collections.emptyList());
    }

    public List<IResourceDescription.Delta> didOpen(URI uri, Integer version, String contents, CancelIndicator cancelIndicator) {
        return this.didOpen(uri, version, contents).build(cancelIndicator);
    }

    public BuildManager.Buildable didOpen(URI uri, Integer version, String contents) {
        this.openDocuments.put(uri, new Document(version, contents));
        return this.didChangeFiles((List<URI>)ImmutableList.of((Object)uri), Collections.emptyList());
    }

    public BuildManager.Buildable didClose(URI uri) {
        this.openDocuments.remove(uri);
        if (this.exists(uri)) {
            return this.didChangeFiles((List<URI>)ImmutableList.of((Object)uri), Collections.emptyList());
        }
        return this.didChangeFiles(Collections.emptyList(), (List<URI>)ImmutableList.of((Object)uri));
    }

    protected boolean exists(URI uri) {
        XtextResourceSet rs;
        ProjectManager projectManager = this.getProjectManager(uri);
        if (projectManager != null && (rs = projectManager.getResourceSet()) != null) {
            return rs.getURIConverter().exists(uri, null);
        }
        return false;
    }

    public <T> T doRead(URI uri, Functions.Function2<? super Document, ? super XtextResource, ? extends T> work) {
        URI resourceURI = uri.trimFragment();
        ProjectManager projectMnr = this.getProjectManager(resourceURI);
        if (projectMnr != null) {
            XtextResource resource = (XtextResource)projectMnr.getResource(resourceURI);
            Document doc = this.getDocument(resource);
            return (T)work.apply((Object)doc, (Object)resource);
        }
        return (T)work.apply(null, null);
    }

    protected Document getDocument(XtextResource resource) {
        Document doc = this.openDocuments.get(resource.getURI());
        if (doc != null) {
            return doc;
        }
        String text = resource.getParseResult().getRootNode().getText();
        return new Document(1, text);
    }

    public boolean isDocumentOpen(URI uri) {
        return this.openDocuments.containsKey(uri);
    }
}

