/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2plc.plcdata;

import java.util.List;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcObject;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcPouType;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcType;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcVariable;
import org.eclipse.escet.common.box.Box;
import org.eclipse.escet.common.box.Boxable;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.box.MemoryCodeBox;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;

public class PlcPou
extends PlcObject {
    public final String name;
    public final PlcPouType pouType;
    public final PlcType retType;
    public List<PlcVariable> inputVars = Lists.list();
    public List<PlcVariable> outputVars = Lists.list();
    public List<PlcVariable> localVars = Lists.list();
    public List<PlcVariable> tempVars = Lists.list();
    public CodeBox body = new MemoryCodeBox(4);
    private int nextTmpVarNr = 0;

    public PlcPou(String name, PlcPouType pouType, PlcType retType) {
        this.name = name;
        this.pouType = pouType;
        this.retType = retType;
    }

    public String addTempVar(PlcType type, String valueTxt) {
        String varName = "tmp" + this.nextTmpVarNr;
        ++this.nextTmpVarNr;
        PlcVariable var = new PlcVariable(varName, type);
        if (this.retType == null) {
            this.tempVars.add(var);
        } else {
            this.localVars.add(var);
        }
        if (valueTxt != null) {
            this.body.add("%s := %s;", new Object[]{varName, valueTxt});
        }
        return varName;
    }

    public Box toBox() {
        CodeBox c = this.headerToBox();
        c.add();
        c.add((Box)this.body);
        c.add("END_%s", new Object[]{this.pouType});
        return c;
    }

    public CodeBox headerToBox() {
        MemoryCodeBox c = new MemoryCodeBox(4);
        String retTypeTxt = this.retType == null ? "" : Strings.fmt((String)": %s", (Object[])new Object[]{this.retType});
        c.add("%s %s%s", new Object[]{this.pouType, this.name, retTypeTxt});
        if (!this.inputVars.isEmpty()) {
            c.add("VAR_INPUT");
            c.indent();
            for (PlcVariable var : this.inputVars) {
                c.add((Boxable)var);
            }
            c.dedent();
            c.add("END_VAR");
        }
        if (!this.outputVars.isEmpty()) {
            c.add("VAR_OUTPUT");
            c.indent();
            for (PlcVariable var : this.outputVars) {
                c.add((Boxable)var);
            }
            c.dedent();
            c.add("END_VAR");
        }
        if (!this.localVars.isEmpty()) {
            c.add("VAR");
            c.indent();
            for (PlcVariable var : this.localVars) {
                c.add((Boxable)var);
            }
            c.dedent();
            c.add("END_VAR");
        }
        if (!this.tempVars.isEmpty()) {
            c.add("VAR_TEMP");
            c.indent();
            for (PlcVariable var : this.tempVars) {
                c.add((Boxable)var);
            }
            c.dedent();
            c.add("END_VAR");
        }
        return c;
    }
}

