/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2plc.writers;

import java.io.File;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcConfiguration;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcPou;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcProject;
import org.eclipse.escet.cif.cif2plc.plcdata.PlcTypeDecl;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.app.framework.exceptions.InvalidInputException;
import org.eclipse.escet.common.box.Box;
import org.eclipse.escet.common.java.Strings;

public class Iec611313Writer {
    private Iec611313Writer() {
    }

    public static void write(PlcProject project, String outPath) {
        File outPathFile = new File(outPath);
        if (!outPathFile.isDirectory()) {
            String msg = Strings.fmt((String)"Failed to write PLC code: path \"%s\" does not exist, or is not a directory.", (Object[])new Object[]{outPath});
            throw new InvalidInputException(msg);
        }
        for (PlcConfiguration config : project.configurations) {
            Iec611313Writer.write(config, outPath);
        }
        for (PlcPou pou : project.pous) {
            Iec611313Writer.write(pou, outPath);
        }
        for (PlcTypeDecl typeDecl : project.typeDecls) {
            Iec611313Writer.write(typeDecl, outPath);
        }
    }

    private static void write(PlcConfiguration config, String outPath) {
        String path = Paths.join((String[])new String[]{outPath, String.valueOf(config.name) + ".plccfg"});
        Box code = config.toBox();
        code.writeToFile(path);
    }

    private static void write(PlcPou pou, String outPath) {
        String ext = pou.retType == null ? ".plcprog" : ".plcfunc";
        String path = Paths.join((String[])new String[]{outPath, String.valueOf(pou.name) + ext});
        Box code = pou.toBox();
        code.writeToFile(path);
    }

    private static void write(PlcTypeDecl typeDecl, String outPath) {
        String path = Paths.join((String[])new String[]{outPath, String.valueOf(typeDecl.name) + ".plctype"});
        Box code = typeDecl.toBox();
        code.writeToFile(path);
    }
}

