/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.app.framework;

import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;

public class SWTUtils {
    private SWTUtils() {
    }

    public static void resize(Shell shell, double fraction) {
        SWTUtils.resize(shell, null, fraction);
    }

    public static void resize(Shell shell, Monitor monitor, double fraction) {
        if (monitor == null) {
            monitor = shell.getDisplay().getPrimaryMonitor();
        }
        shell.setSize((int)((double)monitor.getClientArea().width * fraction), (int)((double)monitor.getClientArea().height * fraction));
    }

    public static void center(Shell shell) {
        SWTUtils.center(shell, null);
    }

    public static void center(Shell shell, Monitor monitor) {
        if (monitor == null) {
            monitor = shell.getDisplay().getPrimaryMonitor();
        }
        Rectangle monitorBounds = monitor.getClientArea();
        Rectangle shellBounds = shell.getBounds();
        int cx = (monitorBounds.width - shellBounds.width) / 2;
        int cy = (monitorBounds.height - shellBounds.height) / 2;
        cx = Math.max(0, cx);
        cy = Math.max(0, cy);
        int x = monitorBounds.x + cx;
        int y = monitorBounds.y + cy;
        shell.setBounds(x, y, shellBounds.width, shellBounds.height);
    }

    public static void exec(Display display, boolean sync, Runnable runnable) {
        if (sync) {
            display.syncExec(runnable);
        } else {
            display.asyncExec(runnable);
        }
    }

    public static void exec(boolean sync, Runnable runnable) {
        SWTUtils.exec(Display.getDefault(), sync, runnable);
    }
}

