/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.app.framework.javacompiler;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.apache.commons.io.IOUtils;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.app.framework.exceptions.InputOutputException;
import org.eclipse.escet.common.java.Strings;

public class InMemoryJarClassLoaderUrlStreamHandler
extends URLStreamHandler {
    protected final String jarPath;
    protected final Map<String, byte[]> entries = new HashMap<String, byte[]>();
    protected final Manifest manifest;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InMemoryJarClassLoaderUrlStreamHandler(String jarPath) {
        this.jarPath = jarPath;
        String absJarPath = Paths.resolve(jarPath);
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                BufferedInputStream fis = new BufferedInputStream(new FileInputStream(absJarPath));
                try {
                    try (JarInputStream jis = new JarInputStream(fis);){
                        JarEntry entry = jis.getNextJarEntry();
                        while (entry != null) {
                            byte[] content = IOUtils.toByteArray((InputStream)jis);
                            this.entries.put("/" + entry.getName(), content);
                            entry = jis.getNextJarEntry();
                        }
                        this.manifest = jis.getManifest();
                    }
                    if (fis == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (fis == null) throw throwable;
                    ((InputStream)fis).close();
                    throw throwable;
                }
                ((InputStream)fis).close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            String msg = Strings.fmt((String)"Could not open or read JAR file \"%s\".", (Object[])new Object[]{jarPath});
            throw new InputOutputException(msg, e);
        }
    }

    public Manifest getManifest() {
        return this.manifest;
    }

    @Override
    protected URLConnection openConnection(URL u) throws IOException {
        String path = u.getFile().toString();
        final byte[] content = this.entries.get(path);
        if (content == null) {
            throw new FileNotFoundException(path);
        }
        return new URLConnection(u){

            @Override
            public void connect() throws IOException {
            }

            @Override
            public InputStream getInputStream() throws IOException {
                return new ByteArrayInputStream(content);
            }
        };
    }
}

