/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.app.framework.javacompiler;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import org.eclipse.escet.common.app.framework.javacompiler.RuntimeJavaCompiler;
import org.eclipse.escet.common.app.framework.javacompiler.RuntimeJavaFileManager;

public class JavaClassFileObject
extends SimpleJavaFileObject {
    private ByteArrayOutputStream byteCode = new ByteArrayOutputStream();
    protected final String absClassName;

    public JavaClassFileObject(String absClassName) {
        super(RuntimeJavaCompiler.createMemoryURI(absClassName, JavaFileObject.Kind.CLASS), JavaFileObject.Kind.CLASS);
        this.absClassName = absClassName = RuntimeJavaFileManager.normalizeName(absClassName);
    }

    @Override
    public String getName() {
        return String.valueOf(this.absClassName.replace(".", "/")) + ".class";
    }

    @Override
    public InputStream openInputStream() {
        return new ByteArrayInputStream(this.getByteCodeArray());
    }

    @Override
    public OutputStream openOutputStream() {
        return this.byteCode;
    }

    public OutputStream getByteCode() {
        return this.byteCode;
    }

    public byte[] getByteCodeArray() {
        return this.byteCode.toByteArray();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JavaClassFileObject)) {
            return false;
        }
        JavaClassFileObject other = (JavaClassFileObject)obj;
        return this.absClassName.equals(other.absClassName);
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ this.absClassName.hashCode();
    }
}

