/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.typechecker;

import java.util.Collections;
import java.util.Set;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.common.java.Sets;

public class ExprContext {
    public static final ExprContext DEFAULT_CTXT = new ExprContext(Collections.EMPTY_SET, null);
    public final Set<Condition> conditions;
    public final CifType receiveType;

    private ExprContext(Set<Condition> conditions, CifType receiveType) {
        this.conditions = Collections.unmodifiableSet(conditions);
        this.receiveType = receiveType;
    }

    public ExprContext add(Condition condition) {
        if (this.conditions.contains((Object)condition)) {
            return this;
        }
        Set newConditions = Sets.copy(this.conditions);
        newConditions.add(condition);
        return new ExprContext(newConditions, this.receiveType);
    }

    public ExprContext remove(Condition condition) {
        if (!this.conditions.contains((Object)condition)) {
            return this;
        }
        Set newConditions = Sets.copy(this.conditions);
        newConditions.remove((Object)condition);
        return new ExprContext(newConditions, this.receiveType);
    }

    public ExprContext setReceiveType(CifType receiveType) {
        if (receiveType == this.receiveType) {
            return this;
        }
        return new ExprContext(this.conditions, receiveType);
    }

    public static enum Condition {
        NO_TIME,
        ALLOW_DIST,
        ALLOW_EVENT;

    }
}

