/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.merger;

import java.util.Set;
import org.eclipse.escet.cif.typechecker.ErrMsg;
import org.eclipse.escet.cif.typechecker.postchk.CifPostCheckEnv;
import org.eclipse.escet.common.app.framework.PlatformUriUtils;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.position.metamodel.position.Position;
import org.eclipse.escet.common.typechecker.SemanticProblemSeverity;

public class CifMergerPostCheckEnv
extends CifPostCheckEnv {
    private final String absCifDirPath;
    public Set<String> errors = Sets.set();

    public CifMergerPostCheckEnv(String absCifDirPath) {
        this.absCifDirPath = absCifDirPath;
    }

    public void addProblem(ErrMsg message, Position position, String ... args) {
        String formattedMsg = message.format(args);
        if (message.getSeverity() == SemanticProblemSeverity.ERROR) {
            this.errors.add(formattedMsg);
        }
    }

    public String resolveImport(String path) {
        return PlatformUriUtils.resolve((String)path, (String)this.absCifDirPath);
    }

    public String getFileReportPath(String absTargetPath, Position position) {
        return PlatformUriUtils.getRelativePath((String)absTargetPath, (String)this.absCifDirPath);
    }

    public void printErrors() {
        if (this.errors.isEmpty()) {
            return;
        }
        OutputProvider.err((String)"Problems detected in merged CIF specification:");
        for (String error : Sets.sortedstrings(this.errors)) {
            OutputProvider.err((String)(" - ERROR: " + error));
        }
    }
}

