/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.java;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.escet.common.java.Lists;

public class ListProductIterator<T>
implements Iterator<List<T>> {
    private final int[] indices;
    private final List<List<T>> data;
    private boolean depleted;

    public ListProductIterator(List<List<T>> data) {
        this.data = data;
        this.indices = new int[data.size()];
        if (data.isEmpty()) {
            this.depleted = true;
        } else {
            for (List<T> subList : data) {
                if (!subList.isEmpty()) continue;
                this.depleted = true;
                break;
            }
        }
    }

    @Override
    public boolean hasNext() {
        return !this.depleted;
    }

    @Override
    public List<T> next() {
        if (this.depleted) {
            throw new NoSuchElementException();
        }
        List<T> rslt = this.current();
        int i = this.indices.length - 1;
        while (i >= 0) {
            int n = i;
            this.indices[n] = this.indices[n] + 1;
            if (this.indices[i] != this.data.get(i).size()) {
                return rslt;
            }
            this.indices[i] = 0;
            --i;
        }
        this.depleted = true;
        return rslt;
    }

    private List<T> current() {
        List rslt = Lists.listc(this.indices.length);
        int i = 0;
        while (i < this.indices.length) {
            rslt.add(this.data.get(i).get(this.indices[i]));
            ++i;
        }
        return rslt;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

