/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.codegen.updates;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.escet.cif.codegen.updates.FindDeclarationUsage;
import org.eclipse.escet.cif.codegen.updates.VariableWrapper;
import org.eclipse.escet.cif.metamodel.cif.declarations.AlgVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.ContVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Sets;

public class AlgDerInvalidations {
    private Map<Declaration, Set<VariableWrapper>> algDerMap;
    private Map<VariableWrapper, Set<VariableWrapper>> invalidatedAlgDerivs;

    public void computeAffects(List<AlgVariable> algVars, List<ContVariable> derivVars) {
        Set accessed;
        this.algDerMap = Maps.mapc((int)(algVars.size() + derivVars.size()));
        for (AlgVariable algVar : algVars) {
            accessed = Sets.set();
            FindDeclarationUsage.collectUse(algVar.getValue(), (Set<VariableWrapper>)accessed);
            this.algDerMap.put((Declaration)algVar, accessed);
        }
        for (ContVariable derivVar : derivVars) {
            accessed = Sets.set();
            FindDeclarationUsage.collectUse(derivVar.getDerivative(), (Set<VariableWrapper>)accessed);
            this.algDerMap.put((Declaration)derivVar, accessed);
        }
        this.invalidatedAlgDerivs = Maps.map();
        for (Declaration decl : this.algDerMap.keySet()) {
            Set<VariableWrapper> access = this.removeAlgDerivs(decl);
            VariableWrapper wrappedAlgDer = new VariableWrapper(decl, decl instanceof ContVariable);
            for (VariableWrapper var : access) {
                this.addInvalidated(var, wrappedAlgDer);
            }
        }
        this.algDerMap = null;
    }

    private Set<VariableWrapper> removeAlgDerivs(Declaration decl) {
        Set<VariableWrapper> accessed = this.algDerMap.get(decl);
        Assert.notNull(accessed);
        Set cleanSet = Sets.set();
        for (VariableWrapper varWrap : accessed) {
            if (varWrap.isDerivative() || varWrap.isAlgebraic()) {
                Set<VariableWrapper> cleanAccess = this.removeAlgDerivs(varWrap.decl);
                cleanSet.addAll(cleanAccess);
                continue;
            }
            cleanSet.add(varWrap);
        }
        this.algDerMap.put(decl, cleanSet);
        return cleanSet;
    }

    private void addInvalidated(VariableWrapper variable, VariableWrapper algDer) {
        Set algDers = this.invalidatedAlgDerivs.get(variable);
        if (algDers == null) {
            algDers = Sets.set((Object)algDer);
            this.invalidatedAlgDerivs.put(variable, algDers);
        } else {
            algDers.add(algDer);
        }
    }

    public Set<VariableWrapper> getAffecting(VariableWrapper d) {
        Set<VariableWrapper> affecting = this.invalidatedAlgDerivs.get(d);
        if (affecting == null) {
            return Collections.EMPTY_SET;
        }
        return affecting;
    }
}

