/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.query;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.query.RepresentationDescriptionQuery;
import org.eclipse.sirius.business.api.session.danalysis.DAnalysisSelector;
import org.eclipse.sirius.business.api.session.danalysis.DAnalysisSessionHelper;
import org.eclipse.sirius.business.internal.representation.DRepresentationLocationManager;
import org.eclipse.sirius.business.internal.session.danalysis.DAnalysisSessionImpl;
import org.eclipse.sirius.business.internal.session.danalysis.DAnalysisSessionServicesImpl;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.DView;
import org.eclipse.sirius.viewpoint.ViewpointFactory;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

public final class DRepresentationDescriptorInternalHelper {
    private DRepresentationDescriptorInternalHelper() {
    }

    public static DRepresentationDescriptor createDescriptor(DRepresentation representation, String representationName, String representationDocumentation) {
        DRepresentationDescriptor descriptor = ViewpointFactory.eINSTANCE.createDRepresentationDescriptor();
        RepresentationDescription description = DialectManager.INSTANCE.getDescription(representation);
        descriptor.setRepresentation(representation);
        descriptor.setDescription(description);
        descriptor.setDocumentation(representationDocumentation);
        descriptor.setName(representationName);
        if (representation instanceof DSemanticDecorator) {
            descriptor.setTarget((EObject)representation.eGet((EStructuralFeature)ViewpointPackage.Literals.DSEMANTIC_DECORATOR__TARGET, false));
        }
        return descriptor;
    }

    public static DRepresentationDescriptor createDRepresentationDescriptor(DRepresentation representation, DAnalysisSessionImpl session, Resource semanticResource, String representationName, String representationDocumentation) {
        if (semanticResource != null) {
            DRepresentationLocationManager representationLocationManager;
            Resource resourceforRepresentation;
            EObject semanticRoot = (EObject)semanticResource.getContents().iterator().next();
            RepresentationDescription description = DialectManager.INSTANCE.getDescription(representation);
            DAnalysisSelector analysisSelector = ((DAnalysisSessionServicesImpl)session.getServices()).getAnalysisSelector();
            Viewpoint viewpoint = new RepresentationDescriptionQuery(description).getParentViewpoint();
            DView dView = DAnalysisSessionHelper.findContainerForAddedRepresentation(semanticRoot, viewpoint, session.allAnalyses(), analysisSelector, representation);
            if (dView == null && (dView = DAnalysisSessionHelper.findFreeContainerForAddedRepresentation(viewpoint, semanticRoot, session.getAnalyses(), analysisSelector, representation)) != null) {
                dView.setViewpoint(viewpoint);
            }
            if (dView == null) {
                dView = ViewpointFactory.eINSTANCE.createDView();
                dView.setViewpoint(viewpoint);
                DAnalysis analysis = DAnalysisSessionHelper.selectAnalysis(viewpoint, session.allAnalyses(), analysisSelector, representation);
                analysis.getOwnedViews().add((Object)dView);
            }
            if ((resourceforRepresentation = (representationLocationManager = ((DAnalysisSessionServicesImpl)session.getServices()).getRepresentationLocationManager()).getOrCreateRepresentationResource(representation, dView.eResource())) != null) {
                session.registerResourceInCrossReferencer(resourceforRepresentation);
                resourceforRepresentation.getContents().add((Object)representation);
            }
            DRepresentationDescriptor descriptor = DRepresentationDescriptorInternalHelper.createDescriptor(representation, representationName, representationDocumentation);
            dView.getOwnedRepresentationDescriptors().add((Object)descriptor);
        }
        return null;
    }
}

