/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.ui.refactoring.resource;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.MoveProcessor;
import org.eclipse.ltk.core.refactoring.participants.MoveRefactoring;
import org.eclipse.ltk.internal.core.refactoring.Messages;
import org.eclipse.ltk.internal.core.refactoring.resource.MoveResourcesProcessor;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIMessages;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.model.WorkbenchViewerComparator;

public class MoveResourcesWizard
extends RefactoringWizard {
    public MoveResourcesWizard(IResource[] resources) {
        super((Refactoring)new MoveRefactoring((MoveProcessor)new MoveResourcesProcessor(resources)), 4);
        this.setDefaultPageTitle(RefactoringUIMessages.MoveResourcesWizard_page_title);
        this.setWindowTitle(RefactoringUIMessages.MoveResourcesWizard_window_title);
    }

    @Override
    protected void addUserInputPages() {
        MoveResourcesProcessor processor = (MoveResourcesProcessor)this.getRefactoring().getAdapter(MoveResourcesProcessor.class);
        this.addPage((IWizardPage)new MoveResourcesRefactoringConfigurationPage(processor));
    }

    private static class MoveResourcesRefactoringConfigurationPage
    extends UserInputWizardPage {
        private final MoveResourcesProcessor fRefactoringProcessor;
        private TreeViewer fDestinationField;

        public MoveResourcesRefactoringConfigurationPage(MoveResourcesProcessor processor) {
            super("MoveResourcesRefactoringConfigurationPage");
            this.fRefactoringProcessor = processor;
        }

        public void createControl(Composite parent) {
            this.initializeDialogUnits((Control)parent);
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout(2, false));
            composite.setLayoutData((Object)new GridData(4, 4, true, true));
            composite.setFont(parent.getFont());
            Label label = new Label(composite, 0);
            IResource[] resourcesToMove = this.fRefactoringProcessor.getResourcesToMove();
            if (resourcesToMove.length == 1) {
                label.setText(Messages.format((String)RefactoringUIMessages.MoveResourcesWizard_description_single, (Object)resourcesToMove[0].getName()));
            } else {
                label.setText(Messages.format((String)RefactoringUIMessages.MoveResourcesWizard_description_multiple, (Object)resourcesToMove.length));
            }
            label.setLayoutData((Object)new GridData());
            this.fDestinationField = new TreeViewer(composite, 2820);
            GridData gd = new GridData(4, 4, true, true, 2, 1);
            gd.widthHint = this.convertWidthInCharsToPixels(40);
            gd.heightHint = this.convertHeightInCharsToPixels(15);
            this.fDestinationField.getTree().setLayoutData((Object)gd);
            this.fDestinationField.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
            this.fDestinationField.setContentProvider((IContentProvider)new BaseWorkbenchContentProvider());
            this.fDestinationField.setComparator((ViewerComparator)new WorkbenchViewerComparator());
            this.fDestinationField.setInput((Object)ResourcesPlugin.getWorkspace());
            this.fDestinationField.addFilter(new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    if (element instanceof IProject) {
                        IProject project = (IProject)element;
                        return project.isAccessible();
                    }
                    return element instanceof IFolder;
                }
            });
            this.fDestinationField.addSelectionChangedListener(event -> this.validatePage());
            if (resourcesToMove.length > 0) {
                this.fDestinationField.setSelection((ISelection)new StructuredSelection((Object)resourcesToMove[0].getParent()));
            }
            this.setPageComplete(false);
            this.setControl((Control)composite);
        }

        @Override
        public void setVisible(boolean visible) {
            if (visible) {
                this.fDestinationField.getTree().setFocus();
                if (this.getErrorMessage() != null) {
                    this.setErrorMessage(null);
                }
            }
            super.setVisible(visible);
        }

        private final void validatePage() {
            RefactoringStatus status;
            IStructuredSelection selection = (IStructuredSelection)this.fDestinationField.getSelection();
            Object firstElement = selection.getFirstElement();
            if (firstElement instanceof IContainer) {
                status = this.fRefactoringProcessor.validateDestination((IContainer)firstElement);
            } else {
                status = new RefactoringStatus();
                status.addError(RefactoringUIMessages.MoveResourcesWizard_error_no_selection);
            }
            this.setPageComplete(status);
        }

        @Override
        protected boolean performFinish() {
            this.initializeRefactoring();
            this.storeSettings();
            return super.performFinish();
        }

        @Override
        public IWizardPage getNextPage() {
            this.initializeRefactoring();
            this.storeSettings();
            return super.getNextPage();
        }

        private void storeSettings() {
        }

        private void initializeRefactoring() {
            IContainer container = (IContainer)((IStructuredSelection)this.fDestinationField.getSelection()).getFirstElement();
            this.fRefactoringProcessor.setDestination(container);
        }
    }
}

