/*******************************************************************************
 * Copyright (c) 2015 itemis AG (http://www.itemis.eu) and others.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * SPDX-License-Identifier: EPL-2.0
 *******************************************************************************/
package org.eclipse.xtext.xtext.generator.parser.antlr

import com.google.inject.Inject
import com.google.inject.Singleton
import org.eclipse.xtext.Grammar
import org.eclipse.xtext.xtext.generator.XtextGeneratorNaming
import org.eclipse.xtext.xtext.generator.model.TypeReference

import static extension org.eclipse.xtext.GrammarUtil.*

@Singleton
class GrammarNaming {

	@Inject
	extension XtextGeneratorNaming
	
	def isCombinedGrammar(Grammar it) {
		CombinedGrammarMarker.findInEmfObject(it).isCombinedGrammar
	}

	protected def String getParserPackage(Grammar it) {
		runtimeBasePackage + ".parser.antlr"
	}

	protected def String getInternalParserPackage(Grammar it) {
		parserPackage + ".internal"
	}

	protected def String getInternalLexerPackage(Grammar it) {
		parserPackage + ".lexer"
	}

	def AntlrGrammar getParserGrammar(Grammar it) {
		new AntlrGrammar(internalParserPackage, '''grammarNamePrefixInternalsimpleNameIF !combinedGrammarParserENDIF''')
	}

	def AntlrGrammar getLexerGrammar(Grammar it) {
		if (combinedGrammar) {
			getParserGrammar
		} else {
			new AntlrGrammar(internalLexerPackage, '''grammarNamePrefixInternalsimpleNameLexer''')
		}
	}
	
	protected def String getGrammarNamePrefix(Grammar it) {
		""
	}

	def TypeReference getLexerClass(Grammar it) {
		new TypeReference(lexerGrammar.packageName, '''lexerGrammar.simpleNameIF combinedGrammarLexerENDIF''')
	}
	
	def TypeReference getLexerSuperClass(Grammar it) {
		new TypeReference("org.eclipse.xtext.parser.antlr.Lexer")
	}

	def TypeReference getParserClass(Grammar it) {
		new TypeReference(parserPackage, '''simpleNameParser''')
	}

	def TypeReference getParserSuperClass(Grammar it, boolean partialParsing) {
		new TypeReference("org.eclipse.xtext.parser.antlr.AbstractAntlrParser")
	}

	def TypeReference getInternalParserClass(Grammar it) {
		new TypeReference(parserGrammar.packageName, '''parserGrammar.simpleNameIF combinedGrammarParserENDIF''')
	}

	def TypeReference getInternalParserSuperClass(Grammar it) {
		new TypeReference("org.eclipse.xtext.parser.antlr.AbstractInternalAntlrParser")
	}

	def TypeReference getAntlrTokenFileProviderClass(Grammar it) {
		new TypeReference(parserPackage, '''simpleNameAntlrTokenFileProvider''')
	}

	def TypeReference getTokenSourceClass(Grammar it) {
		new TypeReference(parserPackage, simpleName + "TokenSource")
	}

}
