/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.setting.services;

import expressions.Expression;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import machine.Axis;
import machine.IResource;
import machine.Peripheral;
import machine.Profile;
import machine.SymbolicPosition;
import org.eclipse.emf.ecore.resource.Resource;
import setting.MotionProfileSettings;
import setting.MotionSettings;
import setting.PhysicalLocation;
import setting.PhysicalSettings;
import setting.SettingUtil;
import setting.Settings;
import setting.impl.MotionArgumentsMapEntryImpl;

public class SettingService {
    public MotionProfileSettings getMotionProfileSettings(MotionSettings settings, Profile profile) {
        return (MotionProfileSettings)settings.getProfileSettings().get((Object)profile);
    }

    public PhysicalLocation getPhysicalLocation(MotionSettings settings, SymbolicPosition symbolicPosition) {
        return (PhysicalLocation)settings.getLocationSettings().get((Object)symbolicPosition.getPosition((Axis)settings.getEntry().getKey()));
    }

    public Collection<MotionArgumentsMapEntryImpl> getMotionParameters(Peripheral peripheral, Axis axis) throws IOException {
        LinkedHashMap<String, MotionArgumentsMapEntryImpl> uniqueMotionArguments = new LinkedHashMap<String, MotionArgumentsMapEntryImpl>();
        for (MotionProfileSettings settings : this.getMotionSettings(peripheral, axis).getProfileSettings().values()) {
            for (Map.Entry entry : settings.getMotionArguments()) {
                uniqueMotionArguments.putIfAbsent((String)entry.getKey(), (MotionArgumentsMapEntryImpl)entry);
            }
        }
        return uniqueMotionArguments.values();
    }

    public String getHeaderLabel(MotionArgumentsMapEntryImpl entry) {
        return entry.getKey();
    }

    public BigDecimal getMotionArgumentValue(MotionArgumentsMapEntryImpl entry, Profile profile) {
        MotionSettings motionSettings = this.getMotionSettings(entry);
        MotionProfileSettings motionProfileSettings = (MotionProfileSettings)motionSettings.getProfileSettings().get((Object)profile);
        if (motionProfileSettings == null) {
            return null;
        }
        Expression exp = (Expression)motionProfileSettings.getMotionArguments().get((Object)entry.getKey());
        return exp == null ? null : exp.evaluate();
    }

    public Collection<Profile> getProfiles(MotionArgumentsMapEntryImpl entry) {
        return this.getMotionSettings(entry).getProfileSettings().keySet();
    }

    private MotionSettings getMotionSettings(MotionArgumentsMapEntryImpl entry) {
        return (MotionSettings)entry.eContainer().eContainer().eContainer();
    }

    public MotionSettings getMotionSettings(Peripheral peripheral, Axis axis) throws IOException {
        return (MotionSettings)this.getPhysicalSettings(peripheral).getMotionSettings().get((Object)axis);
    }

    public PhysicalSettings getPhysicalSettings(Peripheral peripheral) throws IOException {
        Settings setting = SettingUtil.getSettings((Resource)peripheral.eResource());
        IResource resource = null;
        return setting.getPhysicalSettings(resource, peripheral);
    }

    public BigDecimal toBigDecimal(String value) {
        try {
            return new BigDecimal(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

