/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.ludus.api;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.eclipse.lsat.common.ludus.api.MatrixDependencies;
import org.eclipse.lsat.common.ludus.api.MaxPlusException;
import org.eclipse.lsat.common.ludus.backend.algebra.Matrix;
import org.eclipse.lsat.common.ludus.backend.fsm.FSM;
import org.eclipse.lsat.common.ludus.backend.fsm.PrintToCIF;
import org.eclipse.lsat.common.ludus.backend.fsm.impl.Edge;
import org.eclipse.lsat.common.ludus.backend.fsm.impl.FSMImpl;
import org.eclipse.lsat.common.ludus.backend.fsm.impl.Location;
import org.eclipse.lsat.common.ludus.backend.por.ClusterPORPerformance;
import org.eclipse.lsat.common.ludus.backend.por.DependencyGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReductionAlgorithms {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReductionAlgorithms.class);

    private ReductionAlgorithms() {
    }

    public static FSM<Location, Edge> computeClusterReductionPerformance(List<FSM<Location, Edge>> fsmList, Map<String, Matrix> mapping) throws MaxPlusException {
        if (fsmList.isEmpty()) {
            throw new MaxPlusException("The specification contains no FSM.");
        }
        DependencyGraph dependencies = MatrixDependencies.getDependencyGraphResourceSharing(mapping);
        LOGGER.info("Finished calculating the dependencies.");
        ClusterPORPerformance por = new ClusterPORPerformance();
        FSMImpl result = por.compute(fsmList, dependencies);
        LOGGER.info("Computed the reduced FSM with " + result.getVertices().size() + " vertices and " + result.getEdges().size() + " edges.");
        return result;
    }

    public static void writeToFile(FSM<Location, Edge> fsm, String fsmName, String filePath) throws IOException {
        File file = new File(filePath);
        file.createNewFile();
        FileWriter writer = new FileWriter(file);
        writer.write(PrintToCIF.print(fsm, fsmName));
        writer.close();
    }
}

