/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.emf.ecore.resource;

import java.util.HashMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.lsat.common.emf.ecore.resource.Persistor;

public class PersistorFactory {
    private final ResourceSet itsResourceSet;

    public PersistorFactory() {
        this(PersistorFactory.createDefaultResourceSet());
    }

    public PersistorFactory(ResourceSet aResourceSet) {
        this.itsResourceSet = aResourceSet;
    }

    public Persistor<EObject> getPersistor() {
        return this.getPersistor(EObject.class);
    }

    public <T extends EObject> Persistor<T> getPersistor(Class<T> aType) {
        return this.getPersistor(aType, false);
    }

    public <T extends EObject> Persistor<T> getPersistor(Class<T> aType, boolean aMultipleRootTypesAllowed) {
        return this.getPersistor(aType, aMultipleRootTypesAllowed, false);
    }

    public <T extends EObject> Persistor<T> getPersistor(Class<T> aType, boolean aMultipleRootTypesAllowed, boolean aIgnoreProblems) {
        return new Persistor<T>(this.itsResourceSet, aType, aMultipleRootTypesAllowed, aIgnoreProblems);
    }

    public ResourceSet getResourceSet() {
        return this.itsResourceSet;
    }

    public void unloadAll() {
        for (Resource resource : this.itsResourceSet.getResources()) {
            resource.unload();
        }
    }

    private static ResourceSet createDefaultResourceSet() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.setURIResourceMap(new HashMap());
        return resourceSet;
    }
}

