/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.internal;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.eclipse.lsp4e.internal.CharsInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CharsInputStreamTest {
    private static final String TEST_ASCII = "Hello, World!";
    private static final String EMOJI = "\ud83d\ude0a";
    private static final int EMOJI_BYTES_LEN = "\ud83d\ude0a".getBytes(StandardCharsets.UTF_8).length;
    private static final String JAPANESE = "\u3053\u3093\u306b\u3061\u306f";
    private static final String TEST_UNICODE = "\ud83d\ude0a\u3053\u3093\u306b\u3061\u306f";
    private static final int TEST_UNICODE_BYTES_LEN = "\ud83d\ude0a\u3053\u3093\u306b\u3061\u306f".getBytes(StandardCharsets.UTF_8).length;

    @Test
    public void testAvailable() throws IOException {
        CharsInputStream is;
        Throwable throwable = null;
        Object var2_4 = null;
        try {
            is = new CharsInputStream((CharSequence)TEST_ASCII);
            try {
                Assertions.assertEquals((int)TEST_ASCII.length(), (int)is.available());
                byte[] buffer = new byte[4];
                is.read(buffer);
                Assertions.assertEquals((int)(TEST_ASCII.length() - 4), (int)is.available());
                is.readAllBytes();
                Assertions.assertEquals((int)0, (int)is.available());
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var2_4 = null;
        try {
            is = new CharsInputStream((CharSequence)TEST_UNICODE);
            try {
                Assertions.assertTrue((is.available() > 0 ? 1 : 0) != 0);
                is.read(new byte[10]);
                Assertions.assertTrue((is.available() > 0 ? 1 : 0) != 0);
                is.readAllBytes();
                Assertions.assertEquals((int)0, (int)is.available());
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    @Test
    public void testEndOfStream() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (CharsInputStream is = new CharsInputStream((CharSequence)TEST_UNICODE);){
            is.skip(Long.MAX_VALUE);
            Assertions.assertEquals((int)-1, (int)is.read());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testReadEachByte() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (CharsInputStream is = new CharsInputStream((CharSequence)TEST_UNICODE);){
            int b;
            ArrayList<Byte> bytesRead = new ArrayList<Byte>();
            while ((b = is.read()) != -1) {
                bytesRead.add((byte)b);
            }
            byte[] byteArray = new byte[bytesRead.size()];
            int i = 0;
            while (i < bytesRead.size()) {
                byteArray[i] = (Byte)bytesRead.get(i);
                ++i;
            }
            Assertions.assertEquals((Object)TEST_UNICODE, (Object)new String(byteArray, StandardCharsets.UTF_8));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testReadIntoByteArray() throws IOException {
        byte[] buffer = new byte[1024];
        Throwable throwable = null;
        Object var3_4 = null;
        try (CharsInputStream is = new CharsInputStream((CharSequence)TEST_UNICODE);){
            int bytesRead = is.read(buffer, 0, buffer.length);
            Assertions.assertEquals((Object)TEST_UNICODE, (Object)new String(buffer, 0, bytesRead, StandardCharsets.UTF_8));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testSkip() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (CharsInputStream is = new CharsInputStream((CharSequence)TEST_UNICODE);){
            long skipped = is.skip((long)EMOJI_BYTES_LEN);
            Assertions.assertEquals((long)EMOJI_BYTES_LEN, (long)skipped);
            byte[] japanese = new byte[TEST_UNICODE_BYTES_LEN];
            int bytesRead = is.read(japanese);
            Assertions.assertEquals((Object)JAPANESE, (Object)new String(japanese, 0, bytesRead, StandardCharsets.UTF_8));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testHighSurrogateAtEndOfInput() throws IOException {
        char[] invalidSequence = new char[]{'A', '\ud800'};
        Throwable throwable = null;
        Object var3_4 = null;
        try (CharsInputStream is = new CharsInputStream((CharSequence)new String(invalidSequence), StandardCharsets.UTF_8);){
            byte[] result = is.readAllBytes();
            String output = new String(result, StandardCharsets.UTF_8);
            Assertions.assertEquals((Object)"A\ufffd", (Object)output);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testHighSurrogateWithoutLowSurrogate() throws IOException {
        char[] invalidSequence = new char[]{'\ud800', 'A'};
        Throwable throwable = null;
        Object var3_4 = null;
        try (CharsInputStream is = new CharsInputStream((CharSequence)new String(invalidSequence), StandardCharsets.UTF_8);){
            byte[] result = is.readAllBytes();
            String output = new String(result, StandardCharsets.UTF_8);
            Assertions.assertEquals((Object)"\ufffdA", (Object)output);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

