/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.operations.rename;

import java.net.URI;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServers;
import org.eclipse.lsp4e.operations.rename.LSPFileOperationParticipantSupport;
import org.eclipse.lsp4e.test.utils.AbstractTestWithProject;
import org.eclipse.lsp4e.test.utils.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4e.tests.mock.MockWorkspaceService;
import org.eclipse.lsp4j.CreateFilesParams;
import org.eclipse.lsp4j.DeleteFilesParams;
import org.eclipse.lsp4j.FileCreate;
import org.eclipse.lsp4j.FileDelete;
import org.eclipse.lsp4j.FileOperationFilter;
import org.eclipse.lsp4j.FileOperationOptions;
import org.eclipse.lsp4j.FileOperationPattern;
import org.eclipse.lsp4j.FileOperationsServerCapabilities;
import org.eclipse.lsp4j.FileRename;
import org.eclipse.lsp4j.RenameFilesParams;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.WorkspaceServerCapabilities;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class FileOperationParticipantsTest
extends AbstractTestWithProject {
    FileOperationParticipantsTest() {
    }

    @BeforeEach
    void setupCaps() {
        MockLanguageServer.reset(() -> {
            ServerCapabilities caps = MockLanguageServer.defaultServerCapabilities();
            WorkspaceServerCapabilities ws = new WorkspaceServerCapabilities();
            FileOperationsServerCapabilities fileOps = new FileOperationsServerCapabilities();
            fileOps.setWillCreate(new FileOperationOptions());
            fileOps.setWillRename(new FileOperationOptions());
            fileOps.setWillDelete(new FileOperationOptions());
            ws.setFileOperations(fileOps);
            caps.setWorkspace(ws);
            return caps;
        });
    }

    @Test
    void testFilterGlobMatching() throws Exception {
        MockLanguageServer.reset(() -> {
            ServerCapabilities caps = MockLanguageServer.defaultServerCapabilities();
            WorkspaceServerCapabilities ws = new WorkspaceServerCapabilities();
            FileOperationsServerCapabilities fileOps = new FileOperationsServerCapabilities();
            FileOperationPattern pattern = new FileOperationPattern("**/*.lspt");
            FileOperationFilter filter = new FileOperationFilter(pattern, "file");
            FileOperationOptions opts = new FileOperationOptions(List.of(filter));
            fileOps.setWillRename(opts);
            ws.setFileOperations(fileOps);
            caps.setWorkspace(ws);
            return caps;
        });
        IFile file = TestUtils.createUniqueTestFile(this.project, "content");
        TestUtils.openTextViewer(file);
        TestUtils.waitForAndAssertCondition(5000, () -> LanguageServers.forProject((IProject)this.project).anyMatching());
        LanguageServers.LanguageServerProjectExecutor executor = LSPFileOperationParticipantSupport.createFileOperationExecutor((IResource)file, FileOperationsServerCapabilities::getWillRename);
        Assertions.assertTrue((boolean)executor.anyMatching());
    }

    @Test
    void testWillRename() throws Exception {
        IFile file = TestUtils.createUniqueTestFile(this.project, "content");
        TestUtils.openTextViewer(file);
        URI uri = LSPEclipseUtils.toUri((IResource)file);
        Assertions.assertNotNull((Object)uri);
        Assertions.assertTrue((boolean)LanguageServers.forProject((IProject)this.project).anyMatching());
        LanguageServers.LanguageServerProjectExecutor executor = LSPFileOperationParticipantSupport.createFileOperationExecutor((IResource)file, FileOperationsServerCapabilities::getWillRename);
        Assertions.assertTrue((boolean)executor.anyMatching());
        RenameFilesParams params = new RenameFilesParams();
        URI newUri = LSPEclipseUtils.toUri((IResource)this.project.getFile("renamed-" + file.getName()));
        params.getFiles().add(new FileRename(uri.toString(), newUri.toString()));
        LSPFileOperationParticipantSupport.computePreChange((String)"rename", (Object)params, (LanguageServers.LanguageServerProjectExecutor)executor, (ws, p) -> ws.willRenameFiles(p));
        MockWorkspaceService ws2 = MockLanguageServer.INSTANCE.getWorkspaceService();
        Assertions.assertNotNull((Object)ws2.getLastWillRename());
        Assertions.assertEquals((int)1, (int)ws2.getLastWillRename().getFiles().size());
        Assertions.assertEquals((Object)uri.toString(), (Object)((FileRename)ws2.getLastWillRename().getFiles().get(0)).getOldUri());
        Assertions.assertEquals((Object)newUri.toString(), (Object)((FileRename)ws2.getLastWillRename().getFiles().get(0)).getNewUri());
    }

    @Test
    void testWillCreate() throws Exception {
        IFile file = TestUtils.createUniqueTestFile(this.project, "content");
        TestUtils.openTextViewer(file);
        URI uri = LSPEclipseUtils.toUri((IResource)file);
        Assertions.assertNotNull((Object)uri);
        LanguageServers.LanguageServerProjectExecutor executor = LSPFileOperationParticipantSupport.createFileOperationExecutor((IResource)file, FileOperationsServerCapabilities::getWillCreate);
        Assertions.assertTrue((boolean)executor.anyMatching());
        CreateFilesParams params = new CreateFilesParams();
        params.getFiles().add(new FileCreate(uri.toString()));
        LSPFileOperationParticipantSupport.computePreChange((String)"create", (Object)params, (LanguageServers.LanguageServerProjectExecutor)executor, (ws, p) -> ws.willCreateFiles(p));
        MockWorkspaceService ws2 = MockLanguageServer.INSTANCE.getWorkspaceService();
        Assertions.assertNotNull((Object)ws2.getLastWillCreate());
        Assertions.assertEquals((int)1, (int)ws2.getLastWillCreate().getFiles().size());
        Assertions.assertEquals((Object)uri.toString(), (Object)((FileCreate)ws2.getLastWillCreate().getFiles().get(0)).getUri());
    }

    @Test
    void testWillDelete() throws Exception {
        IFile file = TestUtils.createUniqueTestFile(this.project, "content");
        TestUtils.openTextViewer(file);
        URI uri = LSPEclipseUtils.toUri((IResource)file);
        Assertions.assertNotNull((Object)uri);
        LanguageServers.LanguageServerProjectExecutor executor = LSPFileOperationParticipantSupport.createFileOperationExecutor((IResource)file, FileOperationsServerCapabilities::getWillDelete);
        Assertions.assertTrue((boolean)executor.anyMatching());
        DeleteFilesParams params = new DeleteFilesParams();
        params.getFiles().add(new FileDelete(uri.toString()));
        LSPFileOperationParticipantSupport.computePreChange((String)"delete", (Object)params, (LanguageServers.LanguageServerProjectExecutor)executor, (ws, p) -> ws.willDeleteFiles(p));
        MockWorkspaceService ws2 = MockLanguageServer.INSTANCE.getWorkspaceService();
        Assertions.assertNotNull((Object)ws2.getLastWillDelete());
        Assertions.assertEquals((int)1, (int)ws2.getLastWillDelete().getFiles().size());
        Assertions.assertEquals((Object)uri.toString(), (Object)((FileDelete)ws2.getLastWillDelete().getFiles().get(0)).getUri());
    }
}

