/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.jdt;

import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jdt.ui.text.java.IQuickAssistProcessor;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.TextInvocationContext;
import org.eclipse.lsp4e.jdt.LSJavaCompletionWrappingCompletionProposal;
import org.eclipse.lsp4e.jdt.LSJavaProposal;
import org.eclipse.lsp4e.operations.codeactions.LSPCodeActionQuickAssistProcessor;
import org.eclipse.lsp4e.operations.completion.LSCompletionProposal;

public class LspJavaQuickAssistProcessor
extends LSPCodeActionQuickAssistProcessor
implements IQuickAssistProcessor {
    private static final IJavaCompletionProposal[] NO_JAVA_COMPLETION_PROPOSALS = new IJavaCompletionProposal[0];

    private IQuickAssistInvocationContext getContext(final IInvocationContext context) {
        return new IQuickAssistInvocationContext(){

            public ISourceViewer getSourceViewer() {
                return ((TextInvocationContext)context).getSourceViewer();
            }

            public int getOffset() {
                return context.getSelectionOffset();
            }

            public int getLength() {
                return context.getSelectionLength();
            }
        };
    }

    public boolean hasAssists(IInvocationContext context) throws CoreException {
        return this.canAssist(this.getContext(context));
    }

    public IJavaCompletionProposal @Nullable [] getAssists(IInvocationContext context, IProblemLocation[] locations) throws CoreException {
        ICompletionProposal[] proposals = this.computeQuickAssistProposals(this.getContext(context));
        if (proposals == null) {
            return NO_JAVA_COMPLETION_PROPOSALS;
        }
        return (IJavaCompletionProposal[])Arrays.stream(proposals).map(p -> {
            if (p instanceof LSCompletionProposal) {
                LSCompletionProposal lscp = (LSCompletionProposal)p;
                return new LSJavaProposal(lscp);
            }
            return new LSJavaCompletionWrappingCompletionProposal((ICompletionProposal)p);
        }).toArray(IJavaCompletionProposal[]::new);
    }
}

