/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.internal.core.java;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentEdit;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4mp.jdt.core.utils.IJDTUtils;
import org.eclipse.lsp4mp.jdt.internal.core.java.TextEditConverter;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.text.edits.TextEdit;

public class ChangeUtil {
    private static final Range ZERO_RANGE = new Range(new Position(), new Position());

    public static WorkspaceEdit convertToWorkspaceEdit(Change change, String uri, IJDTUtils utils, boolean resourceOperationSupported) throws CoreException {
        WorkspaceEdit edit = new WorkspaceEdit();
        if (change instanceof CompositeChange) {
            ChangeUtil.convertCompositeChange((CompositeChange)change, edit, uri, utils, resourceOperationSupported);
        } else {
            ChangeUtil.convertSingleChange(change, edit, uri, utils, resourceOperationSupported);
        }
        return edit;
    }

    private static void convertCompositeChange(CompositeChange change, WorkspaceEdit edit, String uri, IJDTUtils utils, boolean resourceOperationSupported) throws CoreException {
        Change[] changes;
        Change[] changeArray = changes = change.getChildren();
        int n = changes.length;
        int n2 = 0;
        while (n2 < n) {
            Change ch = changeArray[n2];
            if (ch instanceof CompositeChange) {
                ChangeUtil.convertCompositeChange((CompositeChange)ch, edit, uri, utils, resourceOperationSupported);
            } else {
                ChangeUtil.convertSingleChange(ch, edit, uri, utils, resourceOperationSupported);
            }
            ++n2;
        }
    }

    private static void convertSingleChange(Change change, WorkspaceEdit edit, String uri, IJDTUtils utils, boolean resourceOperationSupported) throws CoreException {
        if (change instanceof CompositeChange) {
            return;
        }
        if (change instanceof TextChange) {
            ChangeUtil.convertTextChange((TextChange)change, edit, uri, utils, resourceOperationSupported);
        }
    }

    private static void convertTextChange(TextChange textChange, WorkspaceEdit rootEdit, String uri, IJDTUtils utils, boolean resourceOperationSupported) {
        Object modifiedElement = textChange.getModifiedElement();
        if (!(modifiedElement instanceof IJavaElement)) {
            return;
        }
        TextEdit textEdits = textChange.getEdit();
        if (textEdits == null) {
            return;
        }
        ICompilationUnit compilationUnit = (ICompilationUnit)((IJavaElement)modifiedElement).getAncestor(5);
        ChangeUtil.convertTextEdit(rootEdit, compilationUnit, textEdits, uri, utils, resourceOperationSupported);
    }

    private static void convertTextEdit(WorkspaceEdit root, ICompilationUnit unit, TextEdit edit, String uri, IJDTUtils utils, boolean resourceOperationSupported) {
        if (edit == null) {
            return;
        }
        TextEditConverter converter = new TextEditConverter(unit, edit, uri, utils);
        if (resourceOperationSupported) {
            ArrayList<Either> changes = root.getDocumentChanges();
            if (changes == null) {
                changes = new ArrayList<Either>();
                root.setDocumentChanges(changes);
            }
            VersionedTextDocumentIdentifier identifier = new VersionedTextDocumentIdentifier(uri, Integer.valueOf(0));
            TextDocumentEdit documentEdit = new TextDocumentEdit(identifier, converter.convert());
            changes.add(Either.forLeft((Object)documentEdit));
        } else {
            Map changes = root.getChanges();
            if (changes.containsKey(uri)) {
                ((List)changes.get(uri)).addAll(converter.convert());
            } else {
                changes.put(uri, converter.convert());
            }
        }
    }

    public static boolean hasChanges(WorkspaceEdit edit) {
        if (edit == null) {
            return false;
        }
        if (edit.getDocumentChanges() != null && !edit.getDocumentChanges().isEmpty()) {
            return true;
        }
        boolean hasChanges = false;
        if (edit.getChanges() != null && !edit.getChanges().isEmpty()) {
            hasChanges = edit.getChanges().values().stream().filter(changes -> changes != null && !changes.isEmpty() && ChangeUtil.hasChanges(changes)).findFirst().isPresent();
        }
        return hasChanges;
    }

    public static boolean hasChanges(List<org.eclipse.lsp4j.TextEdit> edits) {
        if (edits == null) {
            return false;
        }
        return edits.stream().filter(edit -> !edit.getRange().equals((Object)ZERO_RANGE) || !"".equals(edit.getNewText())).findFirst().isPresent();
    }
}

