/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.internal.faulttolerance.java;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4mp.commons.MicroProfileDefinition;
import org.eclipse.lsp4mp.jdt.core.java.definition.AbstractAnnotationDefinitionParticipant;
import org.eclipse.lsp4mp.jdt.core.java.definition.JavaDefinitionContext;
import org.eclipse.lsp4mp.jdt.core.utils.IJDTUtils;
import org.eclipse.lsp4mp.jdt.core.utils.PositionUtils;

public class MicroProfileFaultToleranceDefinitionParticipant
extends AbstractAnnotationDefinitionParticipant {
    public MicroProfileFaultToleranceDefinitionParticipant() {
        super("org.eclipse.microprofile.faulttolerance.Fallback", new String[]{"fallbackMethod"});
    }

    @Override
    protected List<MicroProfileDefinition> collectDefinitions(String annotationValue, Range annotationValueRange, IAnnotation annotation, JavaDefinitionContext context, IProgressMonitor monitor) throws JavaModelException {
        IType type = MicroProfileFaultToleranceDefinitionParticipant.getOwnerType((IJavaElement)annotation);
        if (type != null) {
            ITypeRoot typeRoot = context.getTypeRoot();
            IJDTUtils utils = context.getUtils();
            IMethod[] iMethodArray = type.getMethods();
            int n = iMethodArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod method = iMethodArray[n2];
                if (annotationValue.equals(method.getElementName())) {
                    Range methodNameRange = PositionUtils.toNameRange(method, utils);
                    MicroProfileDefinition definition = new MicroProfileDefinition();
                    LocationLink location = new LocationLink();
                    definition.setLocation(location);
                    location.setTargetUri(utils.toUri(typeRoot));
                    location.setTargetRange(methodNameRange);
                    location.setTargetSelectionRange(methodNameRange);
                    location.setOriginSelectionRange(annotationValueRange);
                    return Arrays.asList(definition);
                }
                ++n2;
            }
        }
        return null;
    }

    private static IType getOwnerType(IJavaElement element) {
        while (element != null) {
            if (element.getElementType() == 7) {
                return (IType)element;
            }
            element = element.getParent();
        }
        return null;
    }

    @Override
    protected boolean isAdaptableFor(IJavaElement definitionElement) {
        return definitionElement.getElementType() == 9;
    }
}

