/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections.component;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.ArrayInt;
import org.eclipse.mat.collect.HashMapIntObject;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.CommandName;
import org.eclipse.mat.query.annotations.HelpUrl;
import org.eclipse.mat.query.annotations.Icon;
import org.eclipse.mat.report.QuerySpec;
import org.eclipse.mat.report.SectionSpec;
import org.eclipse.mat.report.Spec;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.query.SnapshotQuery;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;
import org.eclipse.mat.util.SimpleMonitor;

@CommandName(value="component_report_top")
@HelpUrl(value="/org.eclipse.mat.ui.help/reference/inspections/component_report.html")
@Icon(value="/META-INF/icons/top_components_report.gif")
public class TopComponentsReportQuery
implements IQuery {
    @Argument
    public ISnapshot snapshot;
    @Argument(isMandatory=false, flag="t")
    public int thresholdPercent = 1;
    @Argument(isMandatory=false)
    public boolean aggressive;

    public IResult execute(IProgressListener listener) throws Exception {
        SimpleMonitor sm = new SimpleMonitor(Messages.TopComponentsReportQuery_TopComponentReports, listener, new int[]{10, 90});
        int[] topDominators = this.snapshot.getImmediateDominatedIds(-1);
        List<Record> loaders = this.createClassLoaderRecords(sm.nextMonitor(), topDominators);
        SectionSpec result = new SectionSpec(Messages.TopComponentsReportQuery_TopComponentReports);
        long totalHeapSize = this.snapshot.getSnapshotInfo().getUsedHeapSize();
        long threshold = totalHeapSize / 100L * (long)this.thresholdPercent;
        int nr = 0;
        for (Record record : loaders) {
            if (record.retainedSize < threshold) break;
            ++nr;
        }
        int[] tasks = new int[nr];
        int nobj = this.snapshot.getSnapshotInfo().getNumberOfObjects();
        long totalheap = this.snapshot.getSnapshotInfo().getUsedHeapSize();
        if (totalheap > 0L) {
            int i = 0;
            while (i < nr) {
                tasks[i] = (int)(loaders.get((int)i).retainedSize * (long)nobj / totalheap);
                ++i;
            }
        } else {
            Arrays.fill(tasks, 100);
        }
        SimpleMonitor sm2 = new SimpleMonitor(Messages.TopComponentsReportQuery_TopComponentReports, sm.nextMonitor(), tasks);
        for (Record record : loaders) {
            if (listener.isCanceled() || record.retainedSize < threshold) break;
            String oql = this.oqlLoader(record.name, record.loaderAddr);
            oql = oql.replace("\"", "\\\"");
            SnapshotQuery query = SnapshotQuery.parse("component_report " + oql + ";", this.snapshot);
            query.setArgument("aggressive", this.aggressive);
            IResult report = query.execute(sm2.nextMonitor());
            QuerySpec spec = new QuerySpec(MessageUtil.format((String)"{0} ({1,number,percent})", (Object[])new Object[]{record.name, (double)record.retainedSize / (double)totalHeapSize}), report);
            spec.set("html.separate_file", Boolean.TRUE.toString());
            spec.setCommand("component_report " + (this.aggressive ? "-aggressive " : "") + oql + ";");
            result.add((Spec)spec);
        }
        return result;
    }

    private String oqlLoader(String name, long loaderAddress) {
        return "select * /* " + name.replace("*/", "* /") + " */ from objects (select objects a from objects (dominators(-1)) a) b" + " where" + " b implements org.eclipse.mat.snapshot.model.IClassLoader and b.@objectAddress = " + loaderAddress + "L or" + " b implements org.eclipse.mat.snapshot.model.IClass and b.@classLoaderAddress = " + loaderAddress + "L or" + " b implements org.eclipse.mat.snapshot.model.IClassLoader = false and b implements org.eclipse.mat.snapshot.model.IClass = false and b.@clazz.@classLoaderAddress = " + loaderAddress + "L";
    }

    private List<Record> createClassLoaderRecords(IProgressListener listener, int[] topDominators) throws SnapshotException {
        HashMapIntObject id2loader = new HashMapIntObject();
        int ii = 0;
        while (ii < topDominators.length) {
            int classLoaderId = this.snapshot.isClass(topDominators[ii]) ? ((IClass)this.snapshot.getObject(topDominators[ii])).getClassLoaderId() : (this.snapshot.isClassLoader(topDominators[ii]) ? topDominators[ii] : this.snapshot.getClassOf(topDominators[ii]).getClassLoaderId());
            Record loaderRecord = (Record)id2loader.get(classLoaderId);
            if (loaderRecord == null) {
                IObject loader = this.snapshot.getObject(classLoaderId);
                String name = loader.getClassSpecificName();
                if (name == null) {
                    name = loader.getTechnicalName();
                }
                loaderRecord = new Record(name, loader.getObjectAddress());
                id2loader.put(classLoaderId, (Object)loaderRecord);
            }
            loaderRecord.objects.add(topDominators[ii]);
            loaderRecord.retainedSize += this.snapshot.getRetainedHeapSize(topDominators[ii]);
            if (ii % 1000 == 0) {
                listener.worked(1);
                if (listener.isCanceled()) {
                    throw new IProgressListener.OperationCanceledException();
                }
            }
            ++ii;
        }
        ArrayList<Record> loaders = new ArrayList<Record>(id2loader.size());
        Iterator ee = id2loader.values();
        while (ee.hasNext()) {
            loaders.add((Record)ee.next());
        }
        Collections.sort(loaders);
        return loaders;
    }

    private static class Record
    implements Comparable<Record> {
        String name;
        ArrayInt objects = new ArrayInt();
        long retainedSize;
        long loaderAddr;

        public int hashCode() {
            return Objects.hash(this.loaderAddr, this.name, this.retainedSize);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Record other = (Record)obj;
            return this.loaderAddr == other.loaderAddr && Objects.equals(this.name, other.name) && this.retainedSize == other.retainedSize;
        }

        public Record(String name, long addr) {
            this.name = name;
            this.loaderAddr = addr;
        }

        @Override
        public int compareTo(Record other) {
            if (this.retainedSize > other.retainedSize) {
                return -1;
            }
            if (this.retainedSize < other.retainedSize) {
                return 1;
            }
            int r = this.name.compareTo(other.name);
            if (r != 0) {
                return r;
            }
            return Long.compare(this.loaderAddr, other.loaderAddr);
        }
    }
}

