/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections.finalizer;

import java.util.Collection;
import org.eclipse.mat.collect.SetInt;
import org.eclipse.mat.inspections.ReferenceQuery;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.Category;
import org.eclipse.mat.query.annotations.CommandName;
import org.eclipse.mat.query.annotations.HelpUrl;
import org.eclipse.mat.query.annotations.Icon;
import org.eclipse.mat.report.QuerySpec;
import org.eclipse.mat.report.SectionSpec;
import org.eclipse.mat.report.Spec;
import org.eclipse.mat.snapshot.Histogram;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.GCRootInfo;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IInstance;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.ObjectReference;
import org.eclipse.mat.snapshot.query.ObjectListResult;
import org.eclipse.mat.util.IProgressListener;

@CommandName(value="finalizer_queue")
@Category(value="__hidden__")
@Icon(value="/META-INF/icons/finalizer.gif")
@HelpUrl(value="/org.eclipse.mat.ui.help/tasks/analyzingfinalizer.html")
public class FinalizerQueueQuery
implements IQuery {
    @Argument
    public ISnapshot snapshot;
    @Argument(isMandatory=false)
    public Mode mode = Mode.BOTH;

    public IResult execute(IProgressListener listener) throws Exception {
        Collection<IClass> finalizerClasses = this.snapshot.getClassesByName("java.lang.ref.Finalizer", false);
        SetInt result = new SetInt();
        if (finalizerClasses != null && !finalizerClasses.isEmpty()) {
            if (finalizerClasses.size() != 1) {
                throw new Exception(Messages.FinalizerQueueQuery_ErrorMsg_MultipleFinalizerClasses);
            }
            IClass finalizerClass = finalizerClasses.iterator().next();
            IObject queue = (IObject)finalizerClass.resolveValue("queue");
            if (queue != null) {
                IInstance item = (IInstance)queue.resolveValue("head");
                int length = ((Long)queue.resolveValue("queueLength")).intValue();
                int threshold = length / 100;
                int worked = 0;
                listener.beginTask(Messages.FinalizerQueueQuery_Msg_ExtractingObjects, length);
                while (item != null) {
                    IInstance next;
                    if (listener.isCanceled()) {
                        throw new IProgressListener.OperationCanceledException();
                    }
                    ObjectReference ref = ReferenceQuery.getReferent(item);
                    if (ref != null) {
                        result.add(ref.getObjectId());
                    }
                    if ((next = (IInstance)item.resolveValue("next")) == item) {
                        next = null;
                    }
                    item = next;
                    if (++worked < threshold) continue;
                    listener.worked(worked);
                    if (listener.isCanceled()) {
                        throw new IProgressListener.OperationCanceledException();
                    }
                    worked = 0;
                }
                listener.done();
            }
        }
        int[] length = this.snapshot.getGCRoots();
        int item = length.length;
        int queue = 0;
        while (queue < item) {
            GCRootInfo[] ifo;
            int root = length[queue];
            GCRootInfo[] gCRootInfoArray = ifo = this.snapshot.getGCRootInfo(root);
            int n = ifo.length;
            int n2 = 0;
            while (n2 < n) {
                GCRootInfo rootInfo = gCRootInfoArray[n2];
                if (rootInfo.getType() == 512) {
                    result.add(rootInfo.getObjectId());
                    break;
                }
                ++n2;
            }
            ++queue;
        }
        SectionSpec spec = new SectionSpec(Messages.FinalizerQueueQuery_ReadyForFinalizerThread);
        ObjectListResult.Outbound objResult = new ObjectListResult.Outbound(this.snapshot, result.toArray());
        QuerySpec objList = new QuerySpec(Messages.FinalizerQueueQuery_ReadyForFinalizerThread_List, (IResult)objResult);
        objList.setCommand("finalizer_queue -mode " + Mode.LIST.name());
        spec.add((Spec)objList);
        Histogram histogramResult = this.snapshot.getHistogram(result.toArray(), listener);
        if (listener.isCanceled()) {
            throw new IProgressListener.OperationCanceledException();
        }
        QuerySpec histogram = new QuerySpec(Messages.FinalizerQueueQuery_ReadyForFinalizerThread_Histogram, (IResult)histogramResult);
        histogram.set("sort_column", Messages.Column_RetainedHeap);
        histogram.set("derived_data_column", "_default_=APPROXIMATE");
        histogram.setCommand("finalizer_queue -mode " + Mode.HISTOGRAM.name());
        spec.add((Spec)histogram);
        switch (this.mode) {
            default: {
                return spec;
            }
            case LIST: {
                return objResult;
            }
            case HISTOGRAM: 
        }
        return histogramResult;
    }

    public static enum Mode {
        BOTH,
        LIST,
        HISTOGRAM;

    }
}

