/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.internal.collectionextract;

import java.util.Stack;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.ArrayInt;
import org.eclipse.mat.collect.SetInt;
import org.eclipse.mat.internal.collectionextract.ExtractionUtils;
import org.eclipse.mat.internal.collectionextract.MapCollectionExtractorBase;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.IObjectArray;

public class TreeMapCollectionExtractor
extends MapCollectionExtractorBase {
    protected final String sizeField;

    public TreeMapCollectionExtractor(String sizeField, String keyField, String valueField) {
        super(keyField, valueField);
        if (sizeField == null) {
            throw new IllegalArgumentException();
        }
        this.sizeField = sizeField;
    }

    @Override
    public boolean hasExtractableArray() {
        return false;
    }

    @Override
    public IObjectArray extractEntries(IObject coll) throws SnapshotException {
        throw new IllegalArgumentException();
    }

    @Override
    public boolean hasExtractableContents() {
        return true;
    }

    @Override
    public int[] extractEntryIds(IObject treeMap) throws SnapshotException {
        IObject root;
        ArrayInt result = new ArrayInt();
        String rootf = "root";
        int dot = this.sizeField.lastIndexOf(".");
        if (dot > 0) {
            rootf = String.valueOf(this.sizeField.substring(0, dot + 1)) + rootf;
        }
        if ((root = (IObject)treeMap.resolveValue(rootf)) == null) {
            return new int[0];
        }
        Stack<IObject> stack = new Stack<IObject>();
        stack.push(root);
        IObject current = root;
        SetInt visited = new SetInt();
        while (stack.size() > 0) {
            current = (IObject)stack.peek();
            IObject left = (IObject)current.resolveValue("left");
            if (left != null && !visited.contains(left.getObjectId())) {
                stack.push(left);
                continue;
            }
            result.add(current.getObjectId());
            visited.add(current.getObjectId());
            stack.pop();
            IObject right = (IObject)current.resolveValue("right");
            if (right == null || visited.contains(right.getObjectId())) continue;
            stack.push(right);
        }
        return result.toArray();
    }

    @Override
    public boolean hasSize() {
        return true;
    }

    @Override
    public Integer getSize(IObject coll) throws SnapshotException {
        return ExtractionUtils.toInteger(coll.resolveValue(this.sizeField));
    }

    @Override
    public Integer getNumberOfNotNullElements(IObject coll) throws SnapshotException {
        return this.getSize(coll);
    }

    @Override
    public boolean hasCollisionRatio() {
        return false;
    }

    @Override
    public Double getCollisionRatio(IObject collection) {
        return null;
    }

    @Override
    public boolean hasFillRatio() {
        return false;
    }

    @Override
    public Double getFillRatio(IObject coll) throws SnapshotException {
        return null;
    }
}

