/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.operations;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.mdht.uml.cda.CDAFactory;
import org.eclipse.mdht.uml.cda.ClinicalDocument;
import org.eclipse.mdht.uml.cda.Patient;
import org.eclipse.mdht.uml.cda.PatientRole;
import org.eclipse.mdht.uml.cda.Section;
import org.eclipse.mdht.uml.cda.StructuredBody;
import org.eclipse.mdht.uml.cda.operations.CDAValidationTest;
import org.eclipse.mdht.uml.cda.operations.ClinicalDocumentOperations;
import org.eclipse.mdht.uml.hl7.datatypes.CD;
import org.eclipse.mdht.uml.hl7.datatypes.CE;
import org.eclipse.mdht.uml.hl7.datatypes.DatatypesFactory;
import org.eclipse.mdht.uml.hl7.datatypes.II;
import org.junit.Assert;
import org.junit.Test;

public class ClinicalDocumentOperationsTest
extends CDAValidationTest {
    protected static final String TEMPLATE_ID = "1.2.3.4";
    protected static final II THE_II = DatatypesFactory.eINSTANCE.createII();
    protected static final String CODE = "code";
    protected static final String CODE_SYSTEM = "codeSystem";
    protected static final String CODE_SYSTEM_NAME = "codeSystemName";
    protected static final String CODE_DISPLAY_NAME = "codeDisplayName";
    protected static final CD THE_CODE = DatatypesFactory.eINSTANCE.createCD("code", "codeSystem", "codeSystemName", "codeDisplayName");
    private static final CDAValidationTest.CDATestCase[] TEST_CASE_ARRAY;

    static {
        THE_II.setRoot(TEMPLATE_ID);
        TEST_CASE_ARRAY = new CDAValidationTest.CDATestCase[]{new CDAValidationTest.CDAAddTestCase("Section"){

            @Override
            protected void doTest(EObject objectToTest, BasicDiagnostic diagnostician, Map<Object, Object> map) {
                Section section = (Section)this.getEObjectToAdd();
                ClinicalDocumentOperations.addSection((ClinicalDocument)((ClinicalDocument)objectToTest), (Section)section);
                Assert.assertTrue((boolean)((Section)ClinicalDocumentOperations.getSections((ClinicalDocument)((ClinicalDocument)objectToTest)).get(0)).equals(section));
            }

            @Override
            protected EObject getEObjectToAdd() {
                return CDAFactory.eINSTANCE.createSection();
            }

            @Override
            protected void doAdd(EObject objectToTest, EObject eObjectToAdd) {
            }

            @Override
            protected EStructuralFeature getFeature() {
                return null;
            }
        }, new CDAValidationTest.CDAGetTestCase("Section"){

            @Override
            protected EObject getEObjectToAdd() {
                return CDAFactory.eINSTANCE.createSection();
            }

            @Override
            protected void doAdd(EObject objectToTest, EObject eObjectToAdd) {
                ((ClinicalDocument)objectToTest).addSection((Section)eObjectToAdd);
            }

            @Override
            protected Object doGet(EObject objectToTest) {
                return ClinicalDocumentOperations.getSections((ClinicalDocument)((ClinicalDocument)objectToTest));
            }

            @Override
            protected boolean isGetGood(EObject eObjectToAdd, Object value) {
                return ((Section)((EList)value).get(0)).equals(eObjectToAdd);
            }
        }, new CDAValidationTest.CDAHasTestCase("Code"){

            @Override
            protected void doTest(EObject objectToTest, BasicDiagnostic diagnostician, Map<Object, Object> map) {
                CE code = DatatypesFactory.eINSTANCE.createCE(ClinicalDocumentOperationsTest.CODE, ClinicalDocumentOperationsTest.CODE_SYSTEM);
                code.setCodeSystemName(ClinicalDocumentOperationsTest.CODE_SYSTEM_NAME);
                ((ClinicalDocument)objectToTest).setCode(code);
                boolean hasIsGood = this.doHas(objectToTest, ClinicalDocumentOperationsTest.TEMPLATE_ID);
                Assert.assertTrue((String)("Has \"" + this.getTestTargetDescription() + "\" failed for \"" + objectToTest.eClass().getName() + "\""), (boolean)hasIsGood);
            }

            @Override
            protected EObject getEObjectToAdd() {
                return null;
            }

            @Override
            protected void doAdd(EObject objectToTest, EObject eObjectToAdd) {
            }

            @Override
            protected boolean doHas(EObject objectToTest, String templateId) {
                return ClinicalDocumentOperations.hasCode((ClinicalDocument)((ClinicalDocument)objectToTest), (String)ClinicalDocumentOperationsTest.CODE, (String)ClinicalDocumentOperationsTest.CODE_SYSTEM, (String)ClinicalDocumentOperationsTest.CODE_SYSTEM_NAME);
            }

            @Override
            protected void doAddTemplateId(EObject eObjectToAdd, II theIi) {
            }
        }, new CDAValidationTest.CDAHasTestCase("TemplateID"){

            @Override
            protected void doTest(EObject objectToTest, BasicDiagnostic diagnostician, Map<Object, Object> map) {
                ((ClinicalDocument)objectToTest).getTemplateIds().add((Object)THE_II);
                boolean hasIsGood = this.doHas(objectToTest, ClinicalDocumentOperationsTest.TEMPLATE_ID);
                Assert.assertTrue((String)("Has \"" + this.getTestTargetDescription() + "\" failed for \"" + objectToTest.eClass().getName() + "\""), (boolean)hasIsGood);
            }

            @Override
            protected EObject getEObjectToAdd() {
                return null;
            }

            @Override
            protected void doAdd(EObject objectToTest, EObject eObjectToAdd) {
            }

            @Override
            protected boolean doHas(EObject objectToTest, String templateId) {
                return ClinicalDocumentOperations.hasTemplateId((ClinicalDocument)((ClinicalDocument)objectToTest), (String)templateId);
            }

            @Override
            protected void doAddTemplateId(EObject eObjectToAdd, II theIi) {
            }
        }, new CDAValidationTest.CDATestCase("SetStructureBody"){

            @Override
            protected void doTest(EObject objectToTest, BasicDiagnostic diagnostician, Map<Object, Object> map) {
                StructuredBody sb = CDAFactory.eINSTANCE.createStructuredBody();
                ClinicalDocumentOperations.setStructuredBody((ClinicalDocument)((ClinicalDocument)objectToTest), (StructuredBody)sb);
                Assert.assertTrue((boolean)((ClinicalDocument)objectToTest).getComponent().getStructuredBody().equals(sb));
            }
        }, new CDAValidationTest.CDATestCase("GetPatients"){

            @Override
            protected void doTest(EObject objectToTest, BasicDiagnostic diagnostician, Map<Object, Object> map) {
                Assert.assertTrue((boolean)ClinicalDocumentOperations.getPatients((ClinicalDocument)((ClinicalDocument)objectToTest)).isEmpty());
                Patient patient = CDAFactory.eINSTANCE.createPatient();
                ClinicalDocumentOperations.addPatient((ClinicalDocument)((ClinicalDocument)objectToTest), (Patient)patient);
                Assert.assertTrue((!ClinicalDocumentOperations.getPatients((ClinicalDocument)((ClinicalDocument)objectToTest)).isEmpty() ? 1 : 0) != 0);
            }
        }, new CDAValidationTest.CDATestCase("GetPatientRoles"){

            @Override
            protected void doTest(EObject objectToTest, BasicDiagnostic diagnostician, Map<Object, Object> map) {
                Assert.assertTrue((boolean)ClinicalDocumentOperations.getPatientRoles((ClinicalDocument)((ClinicalDocument)objectToTest)).isEmpty());
                PatientRole patientRole = CDAFactory.eINSTANCE.createPatientRole();
                ClinicalDocumentOperations.addPatientRole((ClinicalDocument)((ClinicalDocument)objectToTest), (PatientRole)patientRole);
                Assert.assertTrue((!ClinicalDocumentOperations.getPatientRoles((ClinicalDocument)((ClinicalDocument)objectToTest)).isEmpty() ? 1 : 0) != 0);
            }
        }, new CDAValidationTest.CDATestCase("HasSectionTemplate"){

            @Override
            protected void doTest(EObject objectToTest, BasicDiagnostic diagnostician, Map<Object, Object> map) {
                Assert.assertTrue((!ClinicalDocumentOperations.hasSectionTemplate((ClinicalDocument)((ClinicalDocument)objectToTest), (String)ClinicalDocumentOperationsTest.TEMPLATE_ID) ? 1 : 0) != 0);
            }
        }};
    }

    @Override
    protected List<CDAValidationTest.CDATestCase> getTestCases() {
        List<CDAValidationTest.CDATestCase> retValue = super.getTestCases();
        retValue.addAll(Arrays.asList(TEST_CASE_ARRAY));
        return retValue;
    }

    @Override
    protected EObject getObjectToTest() {
        return CDAFactory.eINSTANCE.createClinicalDocument();
    }

    @Test
    public final void testConstructor() {
        ClinicalDocumentOperations cdo = new ClinicalDocumentOperations();
        Assert.assertNotNull((Object)cdo);
    }
}

