/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.tests;

import java.util.LinkedList;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.mdht.uml.cda.util.CDAUtil;

public class DiagnosticOutputHelper {
    public static void processDiagnostic(Diagnostic diagnostic, CDAUtil.ValidationHandler handler) {
        LinkedList<Diagnostic> queue = new LinkedList<Diagnostic>();
        queue.add(diagnostic);
        while (!queue.isEmpty()) {
            Diagnostic d = (Diagnostic)queue.remove();
            DiagnosticOutputHelper.handleDiagnostic(d, handler);
            for (Diagnostic childDiagnostic : d.getChildren()) {
                queue.add(childDiagnostic);
            }
        }
    }

    public static void handleDiagnostic(Diagnostic diagnostic, CDAUtil.ValidationHandler handler) {
        switch (diagnostic.getSeverity()) {
            case 4: {
                handler.handleError(diagnostic);
                break;
            }
            case 2: {
                handler.handleWarning(diagnostic);
                break;
            }
            case 1: {
                handler.handleInfo(diagnostic);
            }
        }
    }
}

