/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.tests;

import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.mdht.uml.cda.tests.DiagnosticOutputHelper;
import org.eclipse.mdht.uml.cda.tests.SystemOutValidationHandler;
import org.eclipse.mdht.uml.hl7.datatypes.CD;
import org.eclipse.mdht.uml.hl7.datatypes.CR;
import org.eclipse.mdht.uml.hl7.datatypes.DatatypesFactory;
import org.eclipse.mdht.uml.hl7.datatypes.ED;
import org.eclipse.mdht.uml.hl7.datatypes.EIVL_event;

public class EIVLEventTest {
    private static boolean diagnosticsHaveErrors(Diagnostic oDiagnostic) {
        return oDiagnostic.getSeverity() != 0;
    }

    private static boolean processDiagnostics(Diagnostic oDiagnostic) {
        boolean bResult = true;
        if (EIVLEventTest.diagnosticsHaveErrors(oDiagnostic)) {
            SystemOutValidationHandler oValHandler = new SystemOutValidationHandler();
            DiagnosticOutputHelper.processDiagnostic(oDiagnostic, oValHandler);
            bResult = false;
        }
        return bResult;
    }

    public static boolean testCodeValidValue() {
        EIVL_event oEivlEvent = DatatypesFactory.eINSTANCE.createEIVL_event();
        oEivlEvent.setCode("AC");
        Diagnostic oDiagnostic = Diagnostician.INSTANCE.validate((EObject)oEivlEvent);
        return EIVLEventTest.processDiagnostics(oDiagnostic);
    }

    public static boolean testCodeInvalidValue_FailureCase() {
        boolean bResult = true;
        EIVL_event oEivlEvent = DatatypesFactory.eINSTANCE.createEIVL_event();
        oEivlEvent.setCode("ZZZ");
        Diagnostic oDiagnostic = Diagnostician.INSTANCE.validate((EObject)oEivlEvent);
        if (!EIVLEventTest.diagnosticsHaveErrors(oDiagnostic)) {
            System.out.println("There should have been a validation error but was not one.");
            bResult = false;
        }
        return bResult;
    }

    public static boolean testCodeSystemValidValue() {
        EIVL_event oEivlEvent = DatatypesFactory.eINSTANCE.createEIVL_event();
        oEivlEvent.setCodeSystem("2.16.840.1.113883.5.139");
        Diagnostic oDiagnostic = Diagnostician.INSTANCE.validate((EObject)oEivlEvent);
        return EIVLEventTest.processDiagnostics(oDiagnostic);
    }

    public static boolean testCodeSystemInvalidValue_FailureCase() {
        boolean bResult = true;
        EIVL_event oEivlEvent = DatatypesFactory.eINSTANCE.createEIVL_event();
        oEivlEvent.setCodeSystem("2.16.840.1.113883.4.139");
        Diagnostic oDiagnostic = Diagnostician.INSTANCE.validate((EObject)oEivlEvent);
        if (!EIVLEventTest.diagnosticsHaveErrors(oDiagnostic)) {
            System.out.println("There should have been a validation error but was not one.");
            bResult = false;
        }
        return bResult;
    }

    public static boolean testCodeSystemNameValidValue() {
        EIVL_event oEivlEvent = DatatypesFactory.eINSTANCE.createEIVL_event();
        oEivlEvent.setCodeSystemName("TimingEvent");
        Diagnostic oDiagnostic = Diagnostician.INSTANCE.validate((EObject)oEivlEvent);
        return EIVLEventTest.processDiagnostics(oDiagnostic);
    }

    public static boolean testCodeSystemNameInvalidValue_FailureCase() {
        boolean bResult = true;
        EIVL_event oEivlEvent = DatatypesFactory.eINSTANCE.createEIVL_event();
        oEivlEvent.setCodeSystemName("SomethingElse");
        Diagnostic oDiagnostic = Diagnostician.INSTANCE.validate((EObject)oEivlEvent);
        if (!EIVLEventTest.diagnosticsHaveErrors(oDiagnostic)) {
            System.out.println("There should have been a validation error but was not one.");
            bResult = false;
        }
        return bResult;
    }

    public static boolean testDisplayNameValidValue() {
        EIVL_event oEivlEvent = DatatypesFactory.eINSTANCE.createEIVL_event();
        oEivlEvent.setDisplayName("AC");
        Diagnostic oDiagnostic = Diagnostician.INSTANCE.validate((EObject)oEivlEvent);
        return EIVLEventTest.processDiagnostics(oDiagnostic);
    }

    public static boolean testDisplayNameInvalidValue_FailureCase() {
        boolean bResult = true;
        EIVL_event oEivlEvent = DatatypesFactory.eINSTANCE.createEIVL_event();
        oEivlEvent.setDisplayName("");
        Diagnostic oDiagnostic = Diagnostician.INSTANCE.validate((EObject)oEivlEvent);
        if (!EIVLEventTest.diagnosticsHaveErrors(oDiagnostic)) {
            System.out.println("There should have been a validation error but was not one.");
            bResult = false;
        }
        return bResult;
    }

    public static boolean testOriginalTextInvalidValue_FailureCase() {
        boolean bResult = true;
        EIVL_event oEivlEvent = DatatypesFactory.eINSTANCE.createEIVL_event();
        ED originalText = DatatypesFactory.eINSTANCE.createED();
        oEivlEvent.setOriginalText(originalText);
        Diagnostic oDiagnostic = Diagnostician.INSTANCE.validate((EObject)oEivlEvent);
        if (!EIVLEventTest.diagnosticsHaveErrors(oDiagnostic)) {
            System.out.println("There should have been a validation error but was not one.");
            bResult = false;
        }
        return bResult;
    }

    public static boolean testQualifierInvalidValue_FailureCase() {
        boolean bResult = true;
        EIVL_event oEivlEvent = DatatypesFactory.eINSTANCE.createEIVL_event();
        CR qualifier = DatatypesFactory.eINSTANCE.createCR();
        oEivlEvent.getQualifiers().add((Object)qualifier);
        Diagnostic oDiagnostic = Diagnostician.INSTANCE.validate((EObject)oEivlEvent);
        if (!EIVLEventTest.diagnosticsHaveErrors(oDiagnostic)) {
            System.out.println("There should have been a validation error but was not one.");
            bResult = false;
        }
        return bResult;
    }

    public static boolean testTranslationInvalidValue_FailureCase() {
        boolean bResult = true;
        EIVL_event oEivlEvent = DatatypesFactory.eINSTANCE.createEIVL_event();
        CD translation = DatatypesFactory.eINSTANCE.createCD();
        oEivlEvent.getTranslations().add((Object)translation);
        Diagnostic oDiagnostic = Diagnostician.INSTANCE.validate((EObject)oEivlEvent);
        if (!EIVLEventTest.diagnosticsHaveErrors(oDiagnostic)) {
            System.out.println("There should have been a validation error but was not one.");
            bResult = false;
        }
        return bResult;
    }

    public static void main(String[] args) throws Exception {
        boolean bFailure = false;
        if (!EIVLEventTest.testCodeValidValue()) {
            bFailure = true;
            System.out.println("testCodeValidValue failed!");
        }
        if (!EIVLEventTest.testCodeInvalidValue_FailureCase()) {
            bFailure = true;
            System.out.println("testCodeInvalidValue failed!");
        }
        if (!EIVLEventTest.testCodeSystemValidValue()) {
            bFailure = true;
            System.out.println("testCodeSystemValidValue failed!");
        }
        if (!EIVLEventTest.testCodeSystemInvalidValue_FailureCase()) {
            bFailure = true;
            System.out.println("testCodeSystemInvalidValue failed!");
        }
        if (!EIVLEventTest.testCodeSystemNameValidValue()) {
            bFailure = true;
            System.out.println("testCodeSystemNameValidValue failed!");
        }
        if (!EIVLEventTest.testCodeSystemNameInvalidValue_FailureCase()) {
            bFailure = true;
            System.out.println("testCodeSystemNameInvalidValue failed!");
        }
        if (!EIVLEventTest.testDisplayNameValidValue()) {
            bFailure = true;
            System.out.println("testDisplayNameValidValue failed!");
        }
        if (!EIVLEventTest.testDisplayNameInvalidValue_FailureCase()) {
            bFailure = true;
            System.out.println("testDisplayNameInvalidValue failed!");
        }
        if (!EIVLEventTest.testOriginalTextInvalidValue_FailureCase()) {
            bFailure = true;
            System.out.println("testOriginalTextInvalidValue failed!");
        }
        if (!EIVLEventTest.testQualifierInvalidValue_FailureCase()) {
            bFailure = true;
            System.out.println("testQualifierInvalidValue failed!");
        }
        if (!EIVLEventTest.testTranslationInvalidValue_FailureCase()) {
            bFailure = true;
            System.out.println("testQualifierInvalidValue failed!");
        }
        if (bFailure) {
            System.out.println("One or more tests Failed!!!");
        } else {
            System.out.println("All tests completed successfully...");
        }
    }
}

