/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.transform;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.mdht.uml.transform.IBaseModelReflection;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;

public abstract class AbstractBaseModelReflection
implements IBaseModelReflection {
    @Override
    public <T> T getAdapter(Class<T> adapterType) {
        T result = adapterType.isInstance(this) ? adapterType.cast(this) : this.adapt(adapterType);
        return result;
    }

    protected <T> T adapt(Class<T> adapterType) {
        return null;
    }

    @Override
    public Package getBaseModel(Element context) {
        Package result = null;
        Package local = context.getNearestPackage();
        while (result == null && local != null) {
            for (Package imported : local.getImportedPackages()) {
                if (!this.isBaseModel(context, imported)) continue;
                result = imported;
                break;
            }
            if (result == null) {
                for (Package imported : local.getImportedPackages()) {
                    result = this.getBaseModel((Element)imported);
                    if (result != null) break;
                }
            }
            local = local.getNestingPackage();
        }
        return result;
    }

    @Override
    public Package getDatatypesModel(Element context) {
        Package result = null;
        Package local = context.getNearestPackage();
        while (result == null && local != null) {
            for (Package imported : local.getImportedPackages()) {
                if (!this.isDatatypesModel(context, imported)) continue;
                result = imported;
                break;
            }
            if (result == null) {
                for (Package imported : local.getImportedPackages()) {
                    result = this.getDatatypesModel((Element)imported);
                    if (result != null) break;
                }
            }
            local = local.getNestingPackage();
        }
        return result;
    }

    @Override
    public <C extends Classifier> C getBaseClass(C userClass) {
        C result = null;
        if (this.isBaseModelElement((Element)userClass, (Element)userClass)) {
            result = userClass;
        } else {
            for (C next : this.getTraceabilityChain(userClass)) {
                if (!this.isBaseModelElement((Element)userClass, (Element)next)) continue;
                result = next;
                break;
            }
        }
        return result;
    }

    @Override
    public <C extends Classifier> C getBaseDatatype(C userDatatype) {
        C result = null;
        if (this.isDatatypesModelElement((Element)userDatatype, (Element)userDatatype)) {
            result = userDatatype;
        } else {
            for (C next : this.getTraceabilityChain(userDatatype)) {
                if (!this.isDatatypesModelElement((Element)userDatatype, (Element)next)) continue;
                result = next;
                break;
            }
        }
        return result;
    }

    private Property getBasePropertyThroughRedefines(Property property) {
        Property pp = null;
        for (Property p : property.getRedefinedProperties()) {
            if (this.isBaseModelElement((Element)property.getClass_(), (Element)p) || this.isDatatypesModelElement((Element)property.getClass_(), (Element)p)) {
                return p;
            }
            pp = this.getBasePropertyThroughRedefines(p);
        }
        if (pp == null) {
            for (Property p : property.getSubsettedProperties()) {
                if (this.isBaseModelElement((Element)property.getClass_(), (Element)p) || this.isDatatypesModelElement((Element)property.getClass_(), (Element)p)) {
                    return p;
                }
                pp = this.getBasePropertyThroughRedefines(p);
            }
        }
        return pp;
    }

    @Override
    public Property getBaseProperty(Classifier owner, Property property) {
        Property result = null;
        block0: for (Classifier next : this.getTraceabilityChain(owner)) {
            for (Property base : next.getAttributes()) {
                if (base.getName() == null || !base.getName().equals(property.getName()) || !this.isBaseModelElement((Element)owner, (Element)base) && !this.isDatatypesModelElement((Element)owner, (Element)base)) continue;
                result = base;
                break block0;
            }
        }
        if (result == null) {
            result = this.getBasePropertyThroughRedefines(property);
        }
        return result;
    }

    protected <C extends Classifier> Iterable<C> getTraceabilityChain(final C userType) {
        return new Iterable<C>(){

            @Override
            public Iterator<C> iterator() {
                return new Iterator<C>(userType){
                    private final Class<? extends C> instanceClass;
                    private final Iterator<Classifier> delegate;
                    private C preparedNext;
                    {
                        this.instanceClass = classifier.getClass();
                        this.delegate = classifier.allParents().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.preparedNext == null) {
                            this.prepareNext();
                        }
                        return this.preparedNext != null;
                    }

                    private void prepareNext() {
                        while (this.delegate.hasNext()) {
                            Classifier next = this.delegate.next();
                            if (!this.instanceClass.isInstance(next)) continue;
                            this.preparedNext = (Classifier)this.instanceClass.cast(next);
                            break;
                        }
                    }

                    @Override
                    public C next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        Object result = this.preparedNext;
                        this.preparedNext = null;
                        return result;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Iterator::remove");
                    }
                };
            }
        };
    }

    @Override
    public boolean isBaseModelElement(Element context, Element base) {
        boolean result = false;
        if (base != null) {
            Package package_ = base.getNearestPackage();
            while (!result && package_ != null) {
                result = this.isBaseModel(context, package_);
                package_ = package_.getNestingPackage();
            }
        }
        return result;
    }

    @Override
    public boolean isDatatypesModelElement(Element context, Element base) {
        boolean result = false;
        if (base != null) {
            Package package_ = base.getNearestPackage();
            while (!result && package_ != null) {
                result = this.isDatatypesModel(context, package_);
                package_ = package_.getNestingPackage();
            }
        }
        return result;
    }

    protected abstract boolean isBaseModel(Element var1, Package var2);

    protected abstract boolean isDatatypesModel(Element var1, Package var2);
}

