/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.transform.ecore;

import java.util.ArrayList;
import org.eclipse.mdht.uml.transform.IBaseModelReflection;
import org.eclipse.mdht.uml.transform.TransformerOptions;
import org.eclipse.mdht.uml.transform.ecore.IEcoreProfileReflection;
import org.eclipse.mdht.uml.transform.ecore.TransformAbstract;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.ValueSpecification;

public class TransformConstraint
extends TransformAbstract {
    private static boolean isQueryConstraint(Constraint constraint) {
        boolean inline = false;
        for (Comment comment : constraint.getOwnedComments()) {
            if (!comment.getBody().startsWith("QUERY")) continue;
            inline = true;
            break;
        }
        return inline;
    }

    public TransformConstraint(TransformerOptions options, IBaseModelReflection baseModelReflection) {
        super(options, baseModelReflection);
    }

    public Object caseConstraint(Constraint constraint) {
        if (constraint.getName() == null || constraint.getName().endsWith("TemplateId")) {
            return null;
        }
        IEcoreProfileReflection.ValidationSeverityKind severity = this.getEcoreProfile().getValidationSeverity((Element)constraint, IEcoreProfileReflection.ValidationStereotypeKind.ANY);
        String message = this.getEcoreProfile().getValidationMessage((Element)constraint, IEcoreProfileReflection.ValidationStereotypeKind.ANY);
        ValueSpecification spec = constraint.getSpecification();
        if (spec instanceof OpaqueExpression) {
            ArrayList languages = new ArrayList(((OpaqueExpression)spec).getLanguages());
            String oclBody = null;
            int i = 0;
            while (i < languages.size()) {
                String lang = (String)languages.get(i);
                if ("OCL".equals(lang)) {
                    oclBody = (String)((OpaqueExpression)spec).getBodies().get(i);
                    break;
                }
                ++i;
            }
            if (oclBody == null) {
                this.removeModelElement((Element)constraint);
                return null;
            }
            ((OpaqueExpression)spec).getLanguages().clear();
            ((OpaqueExpression)spec).getBodies().clear();
            ((OpaqueExpression)spec).getLanguages().add((Object)"OCL");
            ((OpaqueExpression)spec).getBodies().add((Object)oclBody);
        }
        Class constrainedClass = null;
        if (!(constraint.getContext() instanceof Class)) {
            return null;
        }
        constrainedClass = (Class)constraint.getContext();
        String constraintName = this.createConstraintName((NamedElement)constraint);
        constraint.setName(constraintName);
        if (TransformConstraint.isQueryConstraint(constraint)) {
            this.annotateQueryConstraint(constraint, constrainedClass);
        }
        if (severity != null) {
            switch (severity) {
                case INFO: {
                    this.addValidationInfo(constrainedClass, constraint.getName(), message);
                    break;
                }
                case WARNING: {
                    this.addValidationWarning(constrainedClass, constraint.getName(), message);
                    break;
                }
                default: {
                    this.addValidationError(constrainedClass, constraint.getName(), message);
                }
            }
        }
        return constraint;
    }
}

