/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.ui.actions;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.emf.workspace.IWorkspaceCommandStack;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.mdht.uml.ui.actions.UML2AbstractAction;
import org.eclipse.mdht.uml.ui.internal.Logger;
import org.eclipse.mdht.uml.ui.internal.l10n.UML2UIMessages;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;

public class AddUMLPackageAction
extends UML2AbstractAction {
    @Override
    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        if (this.isReadOnly()) {
            action.setEnabled(false);
        }
    }

    public void run(IAction action) {
        try {
            final Element element = this.getSelectedElement();
            if (element != null) {
                AbstractEMFOperation operation = new AbstractEMFOperation(this.editingDomain, UML2UIMessages.AddUMLPackage_operation_title){

                    protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) {
                        if (Package.class.isInstance(element)) {
                            String name = AddUMLPackageAction.this.getUniquePackageName((Package)element, UML2UIMessages.AddUMLPackage_default_name);
                            ((Package)element).createNestedPackage(name);
                            return Status.OK_STATUS;
                        }
                        return Status.CANCEL_STATUS;
                    }
                };
                try {
                    IWorkspaceCommandStack commandStack = (IWorkspaceCommandStack)this.editingDomain.getCommandStack();
                    operation.addContext(commandStack.getDefaultUndoContext());
                    commandStack.getOperationHistory().execute((IUndoableOperation)operation, (IProgressMonitor)new NullProgressMonitor(), (IAdaptable)this.activePart);
                }
                catch (ExecutionException ee) {
                    Logger.logException(ee);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getCause());
        }
    }
}

