/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.common;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.osgi.framework.BundleContext;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class UmlPlugin
extends EMFPlugin {
    public static final String PLUGIN_ID = "org.eclipse.mdht.uml.common";
    public static final UmlPlugin INSTANCE = new UmlPlugin();
    private static Implementation plugin;

    private UmlPlugin() {
        super(new ResourceLocator[0]);
    }

    public ResourceLocator getPluginResourceLocator() {
        return plugin;
    }

    public static void computeModelPathMapExtensions() {
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            IProject[] projects;
            IWorkspaceRoot root = EcorePlugin.getWorkspaceRoot();
            if (root != null && (projects = root.getProjects()) != null) {
                int i = 0;
                int size = projects.length;
                while (i < size) {
                    IFile plugin;
                    IProject project = projects[i];
                    if (project.isOpen() && (plugin = project.getFile("plugin.xml")).exists()) {
                        try {
                            UmlPlugin.processPluginXML(project.getName(), plugin.getContents(true));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    ++i;
                }
            }
        } else {
            UmlPlugin.computeModelPathMapsFromPath();
        }
    }

    private static void computeModelPathMapsFromPath() {
        String PATH_SEPARATOR = System.getProperty("path.separator");
        String JAVA_CLASSPATH = System.getProperty("java.class.path");
        String BIN = "bin";
        String PLUGINXML = "plugin.xml";
        StringTokenizer st = new StringTokenizer(JAVA_CLASSPATH, PATH_SEPARATOR);
        while (st.hasMoreTokens()) {
            String path = st.nextToken();
            if (path.endsWith(".jar") || path.endsWith(".zip") || !path.endsWith("bin")) continue;
            String pluginPath = String.valueOf(path.substring(0, path.lastIndexOf("bin"))) + "plugin.xml";
            try {
                FileInputStream pluginInputSteam = new FileInputStream(pluginPath);
                UmlPlugin.processPluginXML(pluginPath.substring(0, pluginPath.lastIndexOf("plugin.xml")), pluginInputSteam);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void processPluginXML(String location, InputStream pluginStream) throws SAXException, IOException, ParserConfigurationException, XPathExpressionException, ClassNotFoundException, SecurityException, NoSuchFieldException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        Document doc = null;
        XPathExpression expr = null;
        DocumentBuilder builder = factory.newDocumentBuilder();
        doc = builder.parse(new InputSource(pluginStream));
        XPathFactory xFactory = XPathFactory.newInstance();
        XPath xpath = xFactory.newXPath();
        expr = xpath.compile("//plugin/extension[@point='org.eclipse.emf.ecore.uri_mapping']/mapping");
        Object result = expr.evaluate(doc, XPathConstants.NODESET);
        NodeList nodes = (NodeList)result;
        int i = 0;
        while (i < nodes.getLength()) {
            String source = nodes.item(i).getAttributes().getNamedItem("source").getNodeValue();
            String target = nodes.item(i).getAttributes().getNamedItem("target").getNodeValue();
            URI key = URI.createURI((String)source);
            URI value = null;
            value = EMFPlugin.IS_ECLIPSE_RUNNING ? URI.createURI((String)("platform:/plugin/" + location + "/" + target)) : URI.createURI((String)("file://" + location + target));
            URIConverter.URI_MAP.put(key, value);
            ++i;
        }
    }

    public static URI getPathMap(InputStream pluginStream) throws SAXException, IOException, ParserConfigurationException, XPathExpressionException, ClassNotFoundException, SecurityException, NoSuchFieldException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        Document doc = null;
        XPathExpression expr = null;
        DocumentBuilder builder = factory.newDocumentBuilder();
        doc = builder.parse(new InputSource(pluginStream));
        XPathFactory xFactory = XPathFactory.newInstance();
        XPath xpath = xFactory.newXPath();
        expr = xpath.compile("//plugin/extension[@point='org.eclipse.emf.ecore.uri_mapping']/mapping");
        Object result = expr.evaluate(doc, XPathConstants.NODESET);
        URI key = null;
        NodeList nodes = (NodeList)result;
        int i = 0;
        while (i < nodes.getLength()) {
            String source = nodes.item(i).getAttributes().getNamedItem("source").getNodeValue();
            nodes.item(i).getAttributes().getNamedItem("target").getNodeValue();
            key = URI.createURI((String)(String.valueOf(source) + "/"));
            ++i;
        }
        return key;
    }

    public static class Implementation
    extends EMFPlugin.EclipsePlugin {
        public Implementation() {
            plugin = this;
        }

        public void start(BundleContext context) throws Exception {
            super.start(context);
            UmlPlugin.computeModelPathMapExtensions();
        }
    }
}

