/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.common.util;

import com.google.common.base.Equivalence;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.mdht.uml.common.util.CompareResultVisitor;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class ModelCompare {
    private static final Comparator<Element> COMPAREELEMENT = new Comparator<Element>(){

        @Override
        public int compare(Element o1, Element o2) {
            Element owner1 = o1.getOwner();
            Element owner2 = o2.getOwner();
            Package package1 = owner1.getNearestPackage();
            Package package2 = owner2.getNearestPackage();
            if (package1 != null && package2 != null) {
                int result = 0;
                result = package1.getName().compareTo(package2.getName());
                if (result == 0 && owner1 instanceof NamedElement && owner2 instanceof NamedElement && ((NamedElement)owner1).getQualifiedName() != null && ((NamedElement)owner2).getQualifiedName() != null && (result = ((NamedElement)owner1).getQualifiedName().compareTo(((NamedElement)owner2).getQualifiedName())) == 0) {
                    if (o1 instanceof NamedElement && o2 instanceof NamedElement && ((NamedElement)o1).getQualifiedName() != null && ((NamedElement)o2).getQualifiedName() != null) {
                        result = ((NamedElement)o1).getQualifiedName().compareTo(((NamedElement)o2).getQualifiedName());
                    }
                    if (result == 0) {
                        result = ModelCompare.getXmiId((EObject)o1).compareTo(ModelCompare.getXmiId((EObject)o2));
                    }
                }
                return result;
            }
            return ModelCompare.getXmiId((EObject)o1).compareTo(ModelCompare.getXmiId((EObject)o2));
        }
    };
    private static final Comparator<MapDifference.ValueDifference<Element>> COMPAREVALUEDIFFERENCE = new Comparator<MapDifference.ValueDifference<Element>>(){

        @Override
        public int compare(MapDifference.ValueDifference<Element> o1, MapDifference.ValueDifference<Element> o2) {
            return COMPAREELEMENT.compare((Element)o1.leftValue(), (Element)o2.leftValue());
        }
    };

    private static String getXmiId(EObject eObject) {
        Resource xmiResource = eObject.eResource();
        if (xmiResource == null) {
            return null;
        }
        return ((XMLResource)xmiResource).getID(eObject);
    }

    private static HashMap<String, Element> createElementHashMap(Element element) {
        HashMap<String, Element> umlPackageHashMap = new HashMap<String, Element>();
        if (element != null) {
            for (Element e : element.getOwnedElements()) {
                umlPackageHashMap.put(ModelCompare.getXmiId((EObject)e), e);
            }
            for (Element e : element.getAppliedStereotypes()) {
                umlPackageHashMap.put(ModelCompare.getXmiId((EObject)e), e);
            }
        }
        return umlPackageHashMap;
    }

    private static ArrayList<Element> getSortedElements(Collection<Element> elements) {
        ArrayList<Element> sortedElements = new ArrayList<Element>();
        sortedElements.addAll(elements);
        Collections.sort(sortedElements, COMPAREELEMENT);
        return sortedElements;
    }

    private static ArrayList<MapDifference.ValueDifference<Element>> getSortedValueDifference(Collection<MapDifference.ValueDifference<Element>> valueDifferences) {
        ArrayList<MapDifference.ValueDifference<Element>> sortedValueDifferences = new ArrayList<MapDifference.ValueDifference<Element>>();
        sortedValueDifferences.addAll(valueDifferences);
        Collections.sort(sortedValueDifferences, COMPAREVALUEDIFFERENCE);
        return sortedValueDifferences;
    }

    public static void compare(NamedElement element1, NamedElement element2, CompareResultVisitor compareResults) {
        compareResults.startElement(element1);
        HashMap<String, Element> umlPackage1HashMap = ModelCompare.createElementHashMap((Element)element1);
        HashMap<String, Element> umlPackage2HashMap = ModelCompare.createElementHashMap((Element)element2);
        MapDifference diff = Maps.difference(umlPackage1HashMap, umlPackage2HashMap, (Equivalence)ValueEquivalence.ElementEquivalence);
        ArrayList<Element> leftElements = ModelCompare.getSortedElements(diff.entriesOnlyOnLeft().values());
        for (Element eee : leftElements) {
            compareResults.addedElement(element1, eee);
            if (!(eee instanceof Package) && !(eee instanceof Class)) continue;
            ModelCompare.compare((NamedElement)eee, null, compareResults);
        }
        ArrayList<Element> rightElements = ModelCompare.getSortedElements(diff.entriesOnlyOnRight().values());
        for (Element eee : rightElements) {
            compareResults.deletedElement(element1, eee);
        }
        ArrayList<MapDifference.ValueDifference<Element>> differences = ModelCompare.getSortedValueDifference(diff.entriesDiffering().values());
        for (MapDifference.ValueDifference<Element> valueDifference : differences) {
            compareResults.changedElement(element1, (Element)valueDifference.leftValue(), (Element)valueDifference.rightValue());
            if (!(valueDifference.leftValue() instanceof Class) && !(valueDifference.leftValue() instanceof Package)) continue;
            ModelCompare.compare((NamedElement)valueDifference.leftValue(), (NamedElement)valueDifference.rightValue(), compareResults);
        }
        compareResults.endElement(element1);
    }

    private static class Compare
    extends UMLSwitch<Boolean> {
        Element element;

        public Compare(Element element) {
            this.element = element;
        }

        public Boolean caseElement(Element object) {
            return ModelCompare.getXmiId((EObject)object).equals(ModelCompare.getXmiId((EObject)this.element));
        }

        public Boolean caseNamedElement(NamedElement namedElement) {
            if (((NamedElement)this.element).getName() != null) {
                return ((NamedElement)this.element).getName().equals(namedElement.getName());
            }
            return (Boolean)super.caseNamedElement(namedElement);
        }

        public Boolean casePackage(Package object) {
            HashMap umlClassifer2HashMap;
            HashMap umlClassifer1HashMap = ModelCompare.createElementHashMap(this.element);
            MapDifference diff = Maps.difference((Map)umlClassifer1HashMap, (Map)(umlClassifer2HashMap = ModelCompare.createElementHashMap((Element)object)), (Equivalence)ValueEquivalence.ElementEquivalence);
            if (diff.areEqual()) {
                return (Boolean)super.casePackage(object);
            }
            return false;
        }

        public Boolean caseClassifier(Classifier object) {
            HashMap umlClassifer2HashMap;
            HashMap umlClassifer1HashMap = ModelCompare.createElementHashMap(this.element);
            MapDifference diff = Maps.difference((Map)umlClassifer1HashMap, (Map)(umlClassifer2HashMap = ModelCompare.createElementHashMap((Element)object)), (Equivalence)ValueEquivalence.ElementEquivalence);
            if (diff.areEqual()) {
                return (Boolean)super.caseClassifier(object);
            }
            return false;
        }

        public Boolean caseProperty(Property property2) {
            Property property1 = (Property)this.element;
            if (property1.getLower() == property2.getLower() && property1.getUpper() == property2.getUpper()) {
                if (property1.getType() != null && property2.getType() != null && property1.getType().getQualifiedName() != null && property2.getType().getQualifiedName() != null) {
                    if (property1.getType().getQualifiedName().equals(property2.getType().getQualifiedName())) {
                        return (Boolean)super.caseProperty(property2);
                    }
                } else {
                    if (property1.getType() == null && property2.getType() == null) {
                        return (Boolean)super.caseProperty(property2);
                    }
                    if (property1.getType().getQualifiedName() == null && property2.getType().getQualifiedName() == null) {
                        return (Boolean)super.caseProperty(property2);
                    }
                }
            }
            return false;
        }

        public Boolean defaultCase(EObject object) {
            return true;
        }
    }

    private static class ValueEquivalence
    extends Equivalence<Element> {
        static ValueEquivalence ElementEquivalence = new ValueEquivalence();

        private ValueEquivalence() {
        }

        protected boolean doEquivalent(Element arg0, Element arg1) {
            Compare compare = new Compare(arg0);
            boolean result = (Boolean)compare.doSwitch((EObject)arg1);
            return result;
        }

        protected int doHash(Element arg0) {
            return 1;
        }
    }
}

