/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.transform.core;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.mdht.transform.core.FragmentKind;
import org.eclipse.mdht.transform.core.IRule;
import org.eclipse.mdht.transform.core.IRuleFragment;
import org.eclipse.mdht.transform.core.ITransformContext;
import org.eclipse.mdht.transform.core.ITransformMonitor;
import org.eclipse.mdht.transform.core.PhaseBuilder;
import org.eclipse.mdht.transform.core.RuleKind;
import org.eclipse.mdht.transform.core.TransformationBuilder;
import org.eclipse.mdht.transform.core.TransformationException;
import org.eclipse.mdht.transform.core.impl.AbstractRule;
import org.eclipse.mdht.transform.core.impl.AbstractRuleFragment;
import org.eclipse.mdht.transform.core.impl.Phase;

public class RuleBuilder {
    private final PhaseBuilder parent;
    private AbstractRule product;

    RuleBuilder(PhaseBuilder parent, IRule rule) {
        this.parent = parent;
        this.product = (AbstractRule)rule;
    }

    RuleBuilder(PhaseBuilder parent, Phase phase, IRule rule) {
        this(parent, rule);
        if (rule.getPhase() == null) {
            phase.addRule(rule);
            this.product.setPhase(phase);
        } else if (rule.getPhase() != phase) {
            throw new IllegalArgumentException("Rule is already in a different phase: " + rule.getPhase().getID());
        }
    }

    RuleBuilder(PhaseBuilder parent, Phase phase, String id, RuleKind kind, String label) {
        this(parent, phase, new DelegatingRule(id, kind, label));
    }

    public RuleBuilder delegateTo(IRuleDelegate delegate) {
        if (!(this.product instanceof DelegatingRule)) {
            throw new IllegalStateException("Not creating a delegating rule.");
        }
        ((DelegatingRule)this.product).setDelegate(delegate);
        return this;
    }

    public RuleBuilder fragment(IRuleFragment fragment) {
        this.product.addFragment(fragment);
        return this;
    }

    public RuleBuilder before(String label, IFragmentDelegate delegate) {
        return this.before("fragment$" + this.product.getRuleFragments().size(), label, delegate);
    }

    public RuleBuilder before(IFragmentDelegate delegate) {
        return this.before("Before " + this.product.getLabel(), delegate);
    }

    public RuleBuilder before(String id, String label, IFragmentDelegate delegate) {
        DelegatingFragment fragment = new DelegatingFragment(id, FragmentKind.BEFORE, label);
        fragment.setDelegate(delegate);
        return this.fragment(fragment);
    }

    public RuleBuilder after(IFragmentDelegate delegate) {
        return this.after("After " + this.product.getLabel(), delegate);
    }

    public RuleBuilder after(String label, IFragmentDelegate delegate) {
        return this.after("fragment$" + this.product.getRuleFragments().size(), label, delegate);
    }

    public RuleBuilder after(String id, String label, IFragmentDelegate delegate) {
        DelegatingFragment fragment = new DelegatingFragment(id, FragmentKind.AFTER, label);
        fragment.setDelegate(delegate);
        return this.fragment(fragment);
    }

    public RuleBuilder rule(IRule rule) {
        this.checkRule();
        return this.parent.rule(rule);
    }

    public RuleBuilder rule(String id, RuleKind kind, String label) {
        this.checkRule();
        return this.parent.rule(id, kind, label);
    }

    public RuleBuilder rule(String id, RuleKind kind, String label, IRuleDelegate delegate) {
        this.checkRule();
        return this.parent.rule(id, kind, label).delegateTo(delegate);
    }

    public TransformationBuilder done() {
        this.checkRule();
        return this.parent.done();
    }

    private void checkRule() {
        if (this.product instanceof DelegatingRule) {
            this.checkRule((DelegatingRule)this.product);
        }
    }

    private void checkRule(DelegatingRule rule) {
        if (rule.getDelegate() == null) {
            throw new IllegalStateException("Rule does not have a delegate.");
        }
    }

    private static final class DelegatingFragment
    extends AbstractRuleFragment {
        private IFragmentDelegate delegate;

        DelegatingFragment(String id, FragmentKind kind, String label) {
            super(id, kind, label);
        }

        void setDelegate(IFragmentDelegate delegate) {
            this.delegate = delegate;
        }

        IFragmentDelegate getDelegate() {
            return this.delegate;
        }

        @Override
        public Object apply(EObject input, Object output, ITransformMonitor monitor) throws TransformationException {
            return this.getDelegate().apply(input, output, this.getContext(), monitor);
        }
    }

    private static final class DelegatingRule
    extends AbstractRule {
        private IRuleDelegate delegate;

        DelegatingRule(String id, RuleKind kind, String label) {
            super(id, kind, label);
        }

        void setDelegate(IRuleDelegate delegate) {
            this.delegate = delegate;
        }

        IRuleDelegate getDelegate() {
            return this.delegate;
        }

        @Override
        protected Object doApply(EObject input, ITransformMonitor monitor) throws TransformationException {
            return this.getDelegate().apply(input, this.getContext(), monitor);
        }
    }

    public static interface IFragmentDelegate {
        public Object apply(EObject var1, Object var2, ITransformContext var3, ITransformMonitor var4) throws TransformationException;
    }

    public static interface IRuleDelegate {
        public Object apply(EObject var1, ITransformContext var2, ITransformMonitor var3) throws TransformationException;
    }
}

