/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.transform.core.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mdht.transform.core.IPhase;
import org.eclipse.mdht.transform.core.IRule;
import org.eclipse.mdht.transform.core.ITransformContext;
import org.eclipse.mdht.transform.core.ITransformMonitor;
import org.eclipse.mdht.transform.core.ITransformation;
import org.eclipse.mdht.transform.core.PhaseKind;
import org.eclipse.mdht.transform.core.RuleKind;
import org.eclipse.mdht.transform.core.TransformationException;
import org.eclipse.mdht.transform.core.impl.AbortTransformationException;
import org.eclipse.mdht.transform.core.impl.AbstractTransformComponent;
import org.eclipse.mdht.transform.core.impl.DepthFirstWalkRule;
import org.eclipse.mdht.transform.core.impl.InitializeContextRule;
import org.eclipse.mdht.transform.core.impl.SaveModelRule;

public class Phase
extends AbstractTransformComponent<PhaseKind>
implements IPhase {
    private final ITransformation transformation;
    private final List<IRule> rules = new ArrayList<IRule>();

    public Phase(ITransformation transformation, String id, PhaseKind kind, String label) {
        super(id, kind, label);
        this.transformation = transformation;
        this.init(kind);
    }

    private void init(PhaseKind kind) {
        switch (kind) {
            case INITIALIZATION: {
                this.addRule(new InitializeContextRule());
                break;
            }
            case FINALIZATION: {
                this.addRule(new SaveModelRule());
                break;
            }
            default: {
                this.addRule(new DepthFirstWalkRule());
            }
        }
    }

    @Override
    public void initialize(ITransformContext ctx) throws TransformationException {
        super.initialize(ctx);
        for (IRule next : this.rules) {
            try {
                next.initialize(ctx);
            }
            catch (AbortTransformationException e) {
                throw new TransformationException(String.format("Transformation aborted in initialization of rule '%s' (%s).", next.getLabel(), next.getID()), e);
            }
            catch (RuntimeException e) {
                throw new TransformationException(String.format("Uncaught exception in initialization of rule '%s' (%s).", next.getLabel(), next.getID()), e);
            }
        }
    }

    @Override
    public ITransformation getTransformation() {
        return this.transformation;
    }

    @Override
    public List<? extends IRule> getRules() {
        return Collections.unmodifiableList(this.rules);
    }

    @Override
    public IRule getRule(String id) {
        IRule result = null;
        for (IRule next : this.rules) {
            if (!next.getID().equals(id)) continue;
            result = next;
            break;
        }
        return result;
    }

    @Override
    public void execute(Iterable<? extends EObject> inputs, ITransformMonitor monitor) throws TransformationException {
        switch ((PhaseKind)((Object)this.getKind())) {
            case INITIALIZATION: 
            case FINALIZATION: {
                Iterator<? extends EObject> iter = inputs.iterator();
                if (!iter.hasNext()) break;
                EObject input = iter.next();
                for (IRule next : this.rules) {
                    Phase.safeApply(next, input, monitor);
                }
                break;
            }
            default: {
                Iterator<? extends EObject> iterator = inputs.iterator();
                while (iterator.hasNext()) {
                    EObject input;
                    EObject element = input = iterator.next();
                    while (element != null) {
                        Iterator<IRule> ruleIter = this.rules.iterator();
                        element = (EObject)Phase.safeApply(ruleIter.next(), element, monitor);
                        if (element == null) continue;
                        while (ruleIter.hasNext()) {
                            Phase.safeApply(ruleIter.next(), element, monitor);
                        }
                    }
                }
                break block0;
            }
        }
    }

    private static Object safeApply(IRule rule, EObject input, ITransformMonitor monitor) throws TransformationException {
        try {
            return rule.apply(input, monitor);
        }
        catch (AbortTransformationException e) {
            throw new TransformationException(String.format("Transformation aborted in application of rule '%s' to '%s' (%s).", rule.getLabel(), input, rule.getID()), e);
        }
        catch (RuntimeException e) {
            throw new TransformationException(String.format("Uncaught exception in application of rule '%s' to '%s' (%s).", rule.getLabel(), input, rule.getID()), e);
        }
    }

    public final void addRule(IRule rule) {
        this.checkRule(rule);
        ListIterator<IRule> iter = this.rules.listIterator();
        while (iter.hasNext()) {
            IRule cur = iter.next();
            if (rule.getID().equals(cur.getID())) {
                if (rule.getKind() != cur.getKind()) {
                    throw new IllegalArgumentException("Cannot replace a rule with a rule of a different kind.");
                }
                iter.set(rule);
                break;
            }
            if (rule.getKind() == RuleKind.WALK && cur.getKind() == RuleKind.WALK) {
                iter.set(rule);
                break;
            }
            if (cur.getKind().ordinal() <= rule.getKind().ordinal()) continue;
            iter.previous();
            iter.add(rule);
            break;
        }
        if (!iter.hasNext()) {
            iter.add(rule);
        }
    }

    private void checkRule(IRule rule) {
        block0 : switch ((PhaseKind)((Object)this.getKind())) {
            case INITIALIZATION: {
                if (rule.getKind() == RuleKind.INITIALIZATION) break;
                throw new IllegalArgumentException("May only add initialization rules to the initialization phase.");
            }
            case FINALIZATION: {
                switch (rule.getKind()) {
                    case SAVE: 
                    case FINALIZATION: {
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Mafy only add save and finalization rules to the finalization phase.");
            }
        }
    }
}

