/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.validation.internal.operations;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.eclipse.mdht.uml.validation.ConstraintProvider;
import org.eclipse.mdht.uml.validation.Diagnostic;
import org.eclipse.mdht.uml.validation.internal.provider.ValidationProfileUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLPackage;

public class DiagnosticOperations {
    protected DiagnosticOperations() {
    }

    public static IStatus fail(Diagnostic diagnostic, IValidationContext context, EObject target) {
        return ConstraintStatus.createStatus((IValidationContext)context, (EObject)target, Collections.emptyList(), (String)DiagnosticOperations.getMessage(diagnostic), (Object[])new Object[]{target, diagnostic.getBase_Constraint().getName()});
    }

    protected static String getMessage(Diagnostic diagnostic) {
        String result = diagnostic.getMessage();
        if (result == null || result.length() == 0) {
            result = "Constraint ''{1}'' violated by ''{0}''";
        }
        return result;
    }

    public static IStatus fail(Diagnostic diagnostic, IValidationContext context, EObject target, EList<EObject> related) {
        return ConstraintStatus.createStatus((IValidationContext)context, (EObject)target, related, (String)DiagnosticOperations.getMessage(diagnostic), (Object[])new Object[]{target, diagnostic.getBase_Constraint().getName()});
    }

    public static EList<EClass> getTargets(Diagnostic diagnostic) {
        ArrayList<EClass> result = new ArrayList<EClass>(3);
        Constraint constraint = diagnostic.getBase_Constraint();
        if (constraint.getContext() instanceof Class) {
            EClass target = DiagnosticOperations.getEClass((Class)constraint.getContext());
            if (target != null) {
                result.add(target);
            }
        } else {
            for (Element next : constraint.getConstrainedElements()) {
                EClass target;
                if (!(next instanceof Class) || (target = DiagnosticOperations.getEClass((Class)next)) == null || result.contains(target)) continue;
                result.add(target);
            }
        }
        return result.isEmpty() ? ECollections.emptyEList() : new BasicEList.UnmodifiableEList(result.size(), result.toArray());
    }

    public static boolean targets(Diagnostic diagnostic, EObject object) {
        boolean result = false;
        for (EClass next : diagnostic.getTargets()) {
            if (!next.isInstance((Object)object)) continue;
            result = true;
            break;
        }
        return result;
    }

    private static EClass getEClass(Class class_) {
        EClass result = null;
        if (class_ instanceof Stereotype) {
            Profile profile = (Profile)EcoreUtil.getRootContainer((EObject)class_);
            result = (EClass)profile.getDefinition((NamedElement)class_);
        } else {
            result = (EClass)UMLPackage.eINSTANCE.getEClassifier(class_.getName());
        }
        return result;
    }

    public static ConstraintProvider getConstraintProvider(Diagnostic diagnostic) {
        ConstraintProvider result = null;
        Package p = diagnostic.getBase_Constraint().getNearestPackage();
        while (result == null && p != null) {
            result = ValidationProfileUtil.getConstraintProvider((Namespace)p);
            p = p.getNestingPackage();
        }
        return result;
    }
}

