/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.validation.util;

import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.validation.model.EvaluationMode;
import org.eclipse.emf.validation.model.IConstraintStatus;
import org.eclipse.emf.validation.service.IBatchValidator;
import org.eclipse.emf.validation.service.ModelValidationService;

public class EValidatorAdapter
extends EObjectValidator {
    private final EValidator delegate;
    private final IBatchValidator batchValidator;

    public EValidatorAdapter(EValidator delegate) {
        this.delegate = delegate == null ? EObjectValidator.INSTANCE : delegate;
        this.batchValidator = (IBatchValidator)ModelValidationService.getInstance().newValidator(EvaluationMode.BATCH);
        this.batchValidator.setIncludeLiveConstraints(true);
        this.batchValidator.setReportSuccesses(false);
    }

    public boolean validate(EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(eObject.eClass(), eObject, diagnostics, context);
    }

    public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        this.delegate.validate(eClass, eObject, diagnostics, context);
        IStatus status = Status.OK_STATUS;
        if (diagnostics != null && !this.hasProcessed(eObject, context)) {
            status = this.batchValidator.validate(eObject, (IProgressMonitor)new NullProgressMonitor());
            this.processed(eObject, context, status);
            this.appendDiagnostics(status, diagnostics);
        }
        return status.isOK();
    }

    public boolean validate(EDataType eDataType, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return super.validate(eDataType, value, diagnostics, context);
    }

    private void processed(EObject eObject, Map<Object, Object> context, IStatus status) {
        if (context != null) {
            context.put(eObject, status);
        }
    }

    private boolean hasProcessed(EObject eObject, Map<Object, Object> context) {
        boolean result = false;
        if (context != null) {
            while (eObject != null) {
                if (context.containsKey(eObject)) {
                    result = true;
                    eObject = null;
                    continue;
                }
                eObject = eObject.eContainer();
            }
        }
        return result;
    }

    private void appendDiagnostics(IStatus status, DiagnosticChain diagnostics) {
        if (status.isMultiStatus()) {
            IStatus[] children = status.getChildren();
            int i = 0;
            while (i < children.length) {
                this.appendDiagnostics(children[i], diagnostics);
                ++i;
            }
        } else if (status instanceof IConstraintStatus) {
            diagnostics.add((Diagnostic)new BasicDiagnostic(status.getSeverity(), status.getPlugin(), status.getCode(), status.getMessage(), ((IConstraintStatus)status).getResultLocus().toArray()));
        }
    }
}

