/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.ui.properties.sections;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.IWorkspaceCommandStack;
import org.eclipse.gmf.runtime.diagram.ui.properties.sections.AbstractModelerPropertySection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.mdht.uml.common.ui.util.Selections;
import org.eclipse.mdht.uml.ui.properties.internal.Logger;
import org.eclipse.mdht.uml.ui.properties.internal.UML2UIPlugin;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.statushandlers.IStatusAdapterConstants;
import org.eclipse.ui.statushandlers.StatusAdapter;
import org.eclipse.ui.statushandlers.StatusManager;

public abstract class WrapperAwareModelerPropertySection
extends AbstractModelerPropertySection {
    private boolean inputIsWrapper;

    protected boolean isReadOnly() {
        return super.isReadOnly() || this.inputIsWrapper;
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        ISelection unwrapped = Selections.unwrap((ISelection)selection);
        this.inputIsWrapper = unwrapped != selection;
        super.setInput(part, unwrapped);
    }

    protected void errorDialog(IStatus status, String title, String message) {
        StatusAdapter adapter = new StatusAdapter(status);
        if (title != null) {
            adapter.setProperty(IStatusAdapterConstants.TITLE_PROPERTY, (Object)title);
        }
        if (message != null) {
            adapter.setProperty(IStatusAdapterConstants.EXPLANATION_PROPERTY, (Object)message);
        }
        adapter.setProperty(IStatusAdapterConstants.TIMESTAMP_PROPERTY, (Object)System.currentTimeMillis());
        StatusManager.getManager().handle(adapter, 2);
    }

    protected void execute(IUndoableOperation operation) {
        try {
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)this.getEObject());
            try {
                IWorkspaceCommandStack commandStack = (IWorkspaceCommandStack)editingDomain.getCommandStack();
                operation.addContext(commandStack.getDefaultUndoContext());
                IStatus result = commandStack.getOperationHistory().execute(operation, (IProgressMonitor)new NullProgressMonitor(), (IAdaptable)this.getPart());
                if (result != null && result.getSeverity() == 4) {
                    this.errorDialog(result, "Live Model Validation", "Violation of one or more live model validation rules has caused the latest edit(s) to be rolled back.");
                    this.refresh();
                }
            }
            catch (ExecutionException ee) {
                Logger.logException(ee);
                Object status = ee.getCause() instanceof CoreException ? ((CoreException)ee.getCause()).getStatus() : new Status(4, UML2UIPlugin.getPluginId(), "Execution of the latest model edit(s) failed.", (Throwable)ee);
                this.errorDialog((IStatus)status, "Unhandled Exception", "An unexpected exception occurred during execution of a model edit command.");
                this.refresh();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getCause());
        }
    }
}

