/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.transformation.ocl2csharp;

import org.apache.commons.lang.WordUtils;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.mdht.transformation.ocl.OCL2ProgrammingLanguageTransformation;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.OperationCallExp;
import org.eclipse.ocl.expressions.PropertyCallExp;

public abstract class OCL2CSharpTransformation<PK, C, O extends EModelElement, P, EL, PM, S, COA, SSA, CT, CLS, E>
extends OCL2ProgrammingLanguageTransformation<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> {
    public String listfunction(String steps, String body, String function, String i) {
        return String.valueOf(steps) + "." + function + "(" + i + " => " + body + ")";
    }

    public String step(String set, String property) {
        if (set.startsWith("Set(") && set.endsWith(")") && !set.contains(".")) {
            String i = set.substring("Set(".length(), set.length() - ")".length());
            return this.referVar(String.valueOf(i) + "." + property);
        }
        String i = this.newVar();
        return "Flatten(" + this.listfunction(set, String.valueOf(i) + "." + property, "ConvertAll", i) + ")";
    }

    public String iterator(String body, String i, String n, String source) {
        String result = "collect".equals(n) ? "Flatten(" + this.listfunction(source, body, "ConvertAll", i) + ")" : ("forAll".equals(n) ? this.listfunction(source, body, "TrueForAll", i) : ("exists".equals(n) ? this.listfunction(source, body, "Exists", i) : this.listfunction(source, body, "FindAll", i)));
        if ("one".equals(n)) {
            return String.valueOf(this.count(result)) + "==1";
        }
        return result;
    }

    public String compare(String opName, String xpath, String xpath2) {
        if ("=".equals(opName) && (xpath.startsWith("Set(") || xpath.startsWith("Flatten(")) && xpath.endsWith(")")) {
            return String.valueOf(xpath) + ".Contains(" + xpath2 + ")";
        }
        return "One(" + xpath + ")" + this.op(opName) + xpath2;
    }

    public String deepEqual(String operator, String lhs, String rhs) {
        return "Enumerable.SequenceEqual(" + lhs + "," + rhs + ")";
    }

    public String transform(OCLExpression exp) {
        PropertyCallExp propertyCallExp;
        String n;
        if (exp instanceof OperationCallExp) {
            OperationCallExp op = (OperationCallExp)exp;
            String opName = this.getName(op.getReferredOperation());
            if ("first".equals(opName) || "last".equals(opName)) {
                return String.valueOf(this.transform(op.getSource())) + "." + WordUtils.capitalize((String)opName) + "()";
            }
            if ("at".equals(opName)) {
                return String.valueOf(this.transform(op.getSource())) + ".get(" + this.transform((OCLExpression)op.getArgument().get(0)) + ")";
            }
        }
        if (exp instanceof PropertyCallExp && ("high".equals(n = this.getName((propertyCallExp = (PropertyCallExp)exp).getReferredProperty())) || "low".equals(n) || "width".equals(n) || "center".equals(n))) {
            String t = "IVXB_TS";
            if ("center".equals(n)) {
                t = "TS";
            }
            if ("width".equals(n)) {
                t = "PQ";
            }
            String self = this.transform(propertyCallExp.getSource());
            String i = this.newVar();
            String predicate = "getTime<" + t + ">(" + i + ", ItemsChoiceType3." + n + ")";
            return this.listfunction(self, predicate, "ConvertAll", i);
        }
        return super.transform(exp);
    }

    public String typeCast(String object, String type) {
        return String.valueOf(object) + " as " + type;
    }

    public String instanceOf(String object, String type) {
        return String.valueOf(object) + " is " + type;
    }

    public String count(String transform) {
        return String.valueOf(transform) + ".Count";
    }

    public String length(String string) {
        return String.valueOf(string) + ".Length";
    }

    public String contains(String set, String item) {
        return String.valueOf(set) + ".Contains(" + item + ")";
    }

    public String typeof(String typeName) {
        return "typeof(" + typeName + ")";
    }
}

