/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.transform;

import java.util.Collections;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.mdht.uml.cda.core.util.CDAModelConsolidator;
import org.eclipse.mdht.uml.cda.transform.CDAAbstractTransformer;
import org.eclipse.mdht.uml.cda.transform.GenDomainInterface;
import org.eclipse.mdht.uml.cda.transform.internal.Logger;
import org.eclipse.mdht.uml.transform.TransformerOptions;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class DomainTransformer
extends CDAAbstractTransformer {
    private CDAModelConsolidator consolidator = null;
    UMLSwitch<Object> genDomainInterface;

    public DomainTransformer() {
        this(new TransformerOptions());
    }

    public DomainTransformer(TransformerOptions options) {
        this.transformerOptions = options;
    }

    @Override
    public void transformModelElement(Element element) {
        if (this.genDomainInterface == null) {
            this.initialize(element.getNearestPackage());
        }
        try {
            TreeIterator iterator = EcoreUtil.getAllContents(Collections.singletonList(element));
            while (iterator != null && iterator.hasNext()) {
                EObject child = (EObject)iterator.next();
                Class consolidatedClass = null;
                if (!(child instanceof Class)) continue;
                consolidatedClass = this.consolidator != null ? this.consolidator.consolidateClass((Class)child) : (Class)child;
                if (this.transformerOptions.isGenerateDomainInterface() || this.transformerOptions.isGenerateDomainClasses()) {
                    this.genDomainInterface.doSwitch((EObject)consolidatedClass);
                }
                this.transformerOptions.isGenerateBuilderClasses();
            }
        }
        catch (IndexOutOfBoundsException e) {
            Logger.logException(e);
        }
    }

    public void initialize(Package sourcePackage) {
        this.genDomainInterface = new GenDomainInterface(this.transformerOptions, null, this.getBaseModelReflection());
    }

    @Override
    public void saveResources() {
        if (this.consolidator != null) {
            while (!this.consolidator.getImportedClassifiers().isEmpty()) {
                Classifier classifier = (Classifier)this.consolidator.getImportedClassifiers().remove(0);
                this.genDomainInterface.doSwitch((EObject)classifier);
            }
        }
    }
}

