/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.transform;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.mdht.uml.cda.transform.internal.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class PluginXMLUtil {
    public static final String CDA_EXTENSION_POINT = "org.eclipse.mdht.uml.cda.extension";
    public static final String CDA_ENTRY = "entry";
    private IFile pluginXML;

    public PluginXMLUtil(IFile pluginXML) {
        this.pluginXML = pluginXML;
    }

    public void addTemplateExtension(String eClass, String templateId, String nsURI) {
        try {
            DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = null;
            document = this.pluginXML.exists() ? docBuilder.parse(this.pluginXML.getLocation().toFile()) : docBuilder.newDocument();
            Element plugin = document.getDocumentElement();
            if (plugin == null) {
                plugin = document.createElement("plugin");
                document.appendChild(plugin);
            }
            if (!"plugin".equals(plugin.getNodeName())) {
                throw new IllegalArgumentException("File is not valid plugin.xml: " + this.pluginXML.getFullPath());
            }
            Element cdaExtensionPoint = this.findCDAExtensionPoint(document);
            Element entry = this.findEntry(document, cdaExtensionPoint, eClass);
            if (entry == null) {
                entry = document.createElement(CDA_ENTRY);
                cdaExtensionPoint.appendChild(entry);
                entry.setAttribute("eClass", eClass);
                entry.setAttribute("id", templateId);
                entry.setAttribute("nsURI", nsURI);
            } else {
                if (!templateId.equals(entry.getAttribute("id"))) {
                    entry.setAttribute("id", templateId);
                    System.out.println(String.valueOf(eClass) + ": Change template Id to: " + templateId);
                }
                if (!nsURI.equals(entry.getAttribute("nsURI"))) {
                    entry.setAttribute("nsURI", nsURI);
                    System.out.println(String.valueOf(eClass) + ": Change nsURI to: " + nsURI);
                }
            }
            this.save(document, this.pluginXML.getLocation());
        }
        catch (Exception e) {
            Logger.logException(e);
        }
    }

    private Element findCDAExtensionPoint(Document document) {
        Element extPoint = null;
        NodeList nodeList = document.getElementsByTagName("extension");
        int i = 0;
        while (i < nodeList.getLength()) {
            Element element;
            if (nodeList.item(i) instanceof Element && CDA_EXTENSION_POINT.equals((element = (Element)nodeList.item(i)).getAttribute("point"))) {
                extPoint = element;
            }
            ++i;
        }
        if (extPoint == null) {
            extPoint = document.createElement("extension");
            extPoint.setAttribute("point", CDA_EXTENSION_POINT);
            document.getDocumentElement().appendChild(extPoint);
        }
        return extPoint;
    }

    private Element findEntry(Document document, Element extPoint, String eClass) {
        Element entry = null;
        NodeList nodeList = extPoint.getElementsByTagName(CDA_ENTRY);
        int i = 0;
        while (i < nodeList.getLength()) {
            Element element;
            if (nodeList.item(i) instanceof Element && eClass.equals((element = (Element)nodeList.item(i)).getAttribute("eClass"))) {
                entry = element;
            }
            ++i;
        }
        return entry;
    }

    private void save(Document document, IPath filePath) {
        try {
            this.removeWhitespaceNodes(document);
            TransformerFactory factory = TransformerFactory.newInstance();
            factory.setAttribute("indent-number", new Integer(3));
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            FileOutputStream out = new FileOutputStream(filePath.toFile());
            transformer.transform(new DOMSource(document), new StreamResult(new OutputStreamWriter((OutputStream)out, "utf-8")));
            out.close();
            this.pluginXML.getParent().refreshLocal(1, null);
        }
        catch (Exception e) {
            Logger.logException(e);
        }
    }

    private void removeWhitespaceNodes(Node node) {
        ArrayList<Node> removeList = new ArrayList<Node>();
        NodeList childNodes = node.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node child = childNodes.item(i);
            if (child instanceof Text) {
                Text text = (Text)child;
                if (text.getData().trim().length() == 0) {
                    removeList.add(child);
                }
            } else if (child.hasChildNodes()) {
                this.removeWhitespaceNodes(child);
            }
            ++i;
        }
        i = 0;
        while (i < removeList.size()) {
            Node n = (Node)removeList.get(i);
            Node p = n.getParentNode();
            if (p != null) {
                p.removeChild(n);
            }
            ++i;
        }
    }
}

