/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.cda.xml.ui.handlers;

import com.google.common.base.Stopwatch;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mdht.uml.cda.AssignedAuthor;
import org.eclipse.mdht.uml.cda.ClinicalDocument;
import org.eclipse.mdht.uml.cda.Material;
import org.eclipse.mdht.uml.cda.NonXMLBody;
import org.eclipse.mdht.uml.cda.Patient;
import org.eclipse.mdht.uml.cda.Person;
import org.eclipse.mdht.uml.cda.PlayingEntity;
import org.eclipse.mdht.uml.cda.Section;
import org.eclipse.mdht.uml.cda.StrucDocText;
import org.eclipse.mdht.uml.cda.util.CDAUtil;
import org.eclipse.mdht.uml.hl7.datatypes.AD;
import org.eclipse.mdht.uml.hl7.datatypes.ADXP;
import org.eclipse.mdht.uml.hl7.datatypes.BinaryDataEncoding;
import org.eclipse.mdht.uml.hl7.datatypes.DatatypesFactory;
import org.eclipse.mdht.uml.hl7.datatypes.ED;
import org.eclipse.mdht.uml.hl7.datatypes.EN;
import org.eclipse.mdht.uml.hl7.datatypes.ENXP;
import org.eclipse.mdht.uml.hl7.datatypes.II;
import org.eclipse.mdht.uml.hl7.datatypes.PN;
import org.eclipse.mdht.uml.hl7.datatypes.TEL;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class DeidentifyCDAHandler
extends AbstractHandler {
    protected String folderPrefix = "DeIndentified";
    public static final SimpleDateFormat DATE_FORMAT3 = new SimpleDateFormat("yyyyMMdd");
    ArrayDeque<String> names = new ArrayDeque();
    ArrayDeque<String> randomNames = new ArrayDeque();
    HashMap<String, String> randomIds = new HashMap(10000, 0.5f);
    ArrayList<IFile> documents = new ArrayList();
    protected static DecimalFormat format2Places = new DecimalFormat(".##");

    public String getFolderPrefix() {
        return this.folderPrefix;
    }

    public void setFolderPrefix(String folderPrefix) {
        this.folderPrefix = folderPrefix;
    }

    public String getKey(II ii) {
        if (ii.getRoot() != null) {
            if (ii.getExtension() != null) {
                return String.valueOf(ii.getRoot()) + "::" + ii.getExtension();
            }
        } else {
            return "noroot x " + ii.getExtension();
        }
        return "nokey";
    }

    public String getKey(String prefix, II ii) {
        return String.valueOf(prefix) + "\t" + this.getKey(ii);
    }

    public String getKey(String prefix, EN pn) {
        return String.valueOf(prefix) + "\t" + this.getKey(pn);
    }

    public String getKey(EN pn) {
        if (pn.getText() != null && pn.getText().trim().length() > 0) {
            this.names.add(pn.getText());
            this.randomNames.add(RandomStringUtils.randomAlphabetic((int)pn.getText().length()));
            return pn.getText();
        }
        StringBuffer b = new StringBuffer();
        for (ENXP e : pn.getPrefixes()) {
            if (b.length() > 0) {
                b.append(" ");
            }
            this.names.add(e.getText());
            this.randomNames.add(RandomStringUtils.randomAlphabetic((int)pn.getText().length()));
            b.append(e.getText());
        }
        for (ENXP e : pn.getGivens()) {
            if (b.length() > 0) {
                b.append(" ");
            }
            this.names.add(e.getText());
            this.randomNames.add(RandomStringUtils.randomAlphabetic((int)pn.getText().length()));
            b.append(e.getText());
        }
        for (ENXP e : pn.getFamilies()) {
            if (b.length() > 0) {
                b.append(" ");
            }
            this.names.add(e.getText());
            this.randomNames.add(RandomStringUtils.randomAlphabetic((int)pn.getText().length()));
            b.append(e.getText());
        }
        for (ENXP e : pn.getSuffixes()) {
            if (b.length() > 0) {
                b.append(" ");
            }
            this.names.add(e.getText());
            this.randomNames.add(RandomStringUtils.randomAlphabetic((int)pn.getText().length()));
            b.append(e.getText());
        }
        while (this.names.size() > 1000) {
            int i = 0;
            while (i < 100) {
                this.names.removeFirst();
                this.randomNames.removeFirst();
                ++i;
            }
        }
        return b.toString();
    }

    private String lookForExistingAcrossFiles(String slimkey) {
        String randomString = "";
        for (String fatkey : this.randomIds.keySet()) {
            if (!fatkey.endsWith(slimkey)) continue;
            randomString = this.randomIds.get(fatkey);
        }
        return randomString;
    }

    public void deidentifyCDA(final IFile file) throws Exception {
        URI cdaURI = URI.createFileURI((String)file.getLocation().toOSString());
        ClinicalDocument clinicalDocument = null;
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (InputStream is = Files.newInputStream(Paths.get(cdaURI.toFileString(), new String[0]), new OpenOption[0]);){
                clinicalDocument = CDAUtil.load((InputStream)is, null);
                is.close();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Resource.IOWrappedException iowe) {
            System.out.println("error processing " + cdaURI.toFileString());
            return;
        }
        CDAUtil.Query query = new CDAUtil.Query(clinicalDocument);
        CDAUtil.Filter<II> iiFilter = new CDAUtil.Filter<II>(){

            public boolean accept(II ii) {
                if (ii.isNullFlavorDefined()) {
                    return false;
                }
                if ("templateId".equals(ii.eContainingFeature().getName())) {
                    return false;
                }
                if (!"2.16.840.1.113883.1.3".equals(ii.getRoot()) && ii.getExtension() != null && ii.getExtension().trim().length() > 0) {
                    String key = DeidentifyCDAHandler.this.getKey(file.getName(), ii);
                    if (!DeidentifyCDAHandler.this.randomIds.containsKey(key)) {
                        String randomString = DeidentifyCDAHandler.this.lookForExistingAcrossFiles(DeidentifyCDAHandler.this.getKey(ii));
                        if (StringUtils.isEmpty((String)randomString)) {
                            randomString = ii.getExtension() != null ? RandomStringUtils.randomNumeric((int)ii.getExtension().length()) : RandomStringUtils.randomNumeric((int)5);
                        }
                        DeidentifyCDAHandler.this.randomIds.put(key, randomString);
                    }
                    if (DeidentifyCDAHandler.this.randomIds.containsKey(key)) {
                        ii.setExtension(DeidentifyCDAHandler.this.randomIds.get(key));
                    }
                }
                return true;
            }
        };
        query.getEObjects(II.class, (CDAUtil.Filter)iiFilter);
        CDAUtil.Filter<PN> enFilter = new CDAUtil.Filter<PN>(){

            public boolean accept(PN pn) {
                if (pn.eContainer() != null && "assignedPerson".equals(pn.eContainer().eContainingFeature().getName())) {
                    return false;
                }
                if (pn.eContainer() instanceof Material) {
                    return false;
                }
                if (pn.isNullFlavorDefined()) {
                    return false;
                }
                if (pn.eContainer() instanceof PlayingEntity) {
                    return false;
                }
                if (pn.eContainer() instanceof Person && pn.eContainer().eContainer() instanceof AssignedAuthor) {
                    return false;
                }
                if (StringUtils.isEmpty((String)DeidentifyCDAHandler.this.getKey((EN)pn))) {
                    return false;
                }
                String key = DeidentifyCDAHandler.this.getKey(file.getName(), (EN)pn);
                if (!DeidentifyCDAHandler.this.randomIds.containsKey(key)) {
                    String[] randoms = key.split(" ");
                    String randomString = DeidentifyCDAHandler.this.lookForExistingAcrossFiles(DeidentifyCDAHandler.this.getKey((EN)pn));
                    if (StringUtils.isEmpty((String)randomString)) {
                        String newName = key;
                        String[] stringArray = randoms;
                        int n = randoms.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String n3 = stringArray[n2];
                            newName = newName.replace(n3, RandomStringUtils.randomAlphabetic((int)5));
                            ++n2;
                        }
                        randomString = newName;
                    }
                    DeidentifyCDAHandler.this.randomIds.put(key, randomString);
                }
                if (DeidentifyCDAHandler.this.randomIds.containsKey(key)) {
                    pn.getMixed().clear();
                    pn.getPrefixes().clear();
                    pn.getGivens().clear();
                    pn.getFamilies().clear();
                    pn.getSuffixes().clear();
                    pn.addText(DeidentifyCDAHandler.this.randomIds.get(key));
                }
                return true;
            }
        };
        query.getEObjects(PN.class, (CDAUtil.Filter)enFilter);
        CDAUtil.Filter<AD> adFilter = new CDAUtil.Filter<AD>(){

            public boolean accept(AD item) {
                if (item.isNullFlavorDefined()) {
                    return false;
                }
                if (item.getText() != null && item.getText().trim().length() > 0) {
                    item.getMixed().clear();
                    item.addText(RandomStringUtils.randomAlphabetic((int)5));
                }
                for (ADXP a : item.getStreetAddressLines()) {
                    a.getMixed().clear();
                    a.addText(RandomStringUtils.randomAlphabetic((int)5));
                }
                for (ADXP a : item.getCities()) {
                    a.getMixed().clear();
                    a.addText(RandomStringUtils.randomAlphabetic((int)5));
                }
                for (ADXP a : item.getCounties()) {
                    a.getMixed().clear();
                    a.addText(RandomStringUtils.randomAlphabetic((int)5));
                }
                for (ADXP a : item.getCountries()) {
                    a.getMixed().clear();
                    a.addText(RandomStringUtils.randomAlphabetic((int)5));
                }
                for (ADXP a : item.getStates()) {
                    a.getMixed().clear();
                    a.addText(RandomStringUtils.randomAlphabetic((int)5));
                }
                for (ADXP a : item.getStreetNames()) {
                    a.getMixed().clear();
                    a.addText(RandomStringUtils.randomAlphabetic((int)5));
                }
                for (ADXP a : item.getPostalCodes()) {
                    a.getMixed().clear();
                    a.addText(RandomStringUtils.randomAlphabetic((int)5));
                }
                return true;
            }
        };
        query.getEObjects(AD.class, (CDAUtil.Filter)adFilter);
        CDAUtil.Filter<TEL> telFilter = new CDAUtil.Filter<TEL>(){

            public boolean accept(TEL item) {
                if (item.isNullFlavorDefined()) {
                    return false;
                }
                String avalue = item.getValue();
                if (!StringUtils.isEmpty((String)avalue) && avalue.indexOf(35) == 0) {
                    return false;
                }
                item.setValue(RandomStringUtils.randomAlphabetic((int)5));
                return false;
            }
        };
        query.getEObjects(TEL.class, (CDAUtil.Filter)telFilter);
        CDAUtil.Filter<Section> sectionFilter = new CDAUtil.Filter<Section>(){

            public boolean accept(Section item) {
                if (item.getText() != null) {
                    ByteArrayOutputStream fa = new ByteArrayOutputStream();
                    try {
                        CDAUtil.saveSnippet((EObject)EcoreUtil.copy((EObject)item.getText()), (OutputStream)fa);
                        String newText = fa.toString();
                        String[] sourceNames = DeidentifyCDAHandler.this.names.toArray(new String[0]);
                        String[] targetNames = DeidentifyCDAHandler.this.randomNames.toArray(new String[0]);
                        StringUtils.replaceEach((String)newText, (String[])sourceNames, (String[])targetNames);
                        StrucDocText hhh = item.createStrucDocText(newText.substring(37, newText.length() - 15));
                        item.setText(hhh);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                return false;
            }
        };
        query.getEObjects(Section.class, (CDAUtil.Filter)sectionFilter);
        CDAUtil.Filter<Patient> patientFilter = new CDAUtil.Filter<Patient>(){

            public boolean accept(Patient item) {
                if (item.getBirthTime() != null && !StringUtils.isEmpty((String)item.getBirthTime().getValue())) {
                    String currentDate = item.getBirthTime().getValue();
                    if (currentDate.length() < 4) {
                        currentDate = String.valueOf(currentDate) + "0000";
                    }
                    item.getBirthTime().setValue(String.valueOf(currentDate.substring(0, 4)) + "01");
                }
                return false;
            }
        };
        query.getEObjects(Patient.class, (CDAUtil.Filter)patientFilter);
        CDAUtil.Filter<NonXMLBody> nonXMLBodyFilter = new CDAUtil.Filter<NonXMLBody>(){

            public boolean accept(NonXMLBody item) {
                ED ed = DatatypesFactory.eINSTANCE.createED("NON XML CONTENT REMOVED AS PART OF DEINDENTIFICATION");
                ed.setMediaType("text/plain");
                ed.setRepresentation(BinaryDataEncoding.TXT);
                item.setText(ed);
                return false;
            }
        };
        query.getEObjects(NonXMLBody.class, (CDAUtil.Filter)nonXMLBodyFilter);
        if (file.getParent() != null) {
            IPath p = file.getParent().getProjectRelativePath();
            p = p.append(this.folderPrefix);
            IFolder f = file.getProject().getFolder(p);
            if (!f.exists()) {
                f.create(true, true, null);
            }
            int i = file.getName().lastIndexOf(file.getFileExtension());
            IFile df = f.getFile(String.valueOf(file.getName().substring(0, i - 1)) + "_DeIdentified.xml");
            Throwable throwable = null;
            Object var17_21 = null;
            try (OutputStream fileOut = Files.newOutputStream(Paths.get(df.getLocation().toOSString(), new String[0]), new OpenOption[0]);){
                CDAUtil.save((ClinicalDocument)clinicalDocument, (OutputStream)fileOut);
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        clinicalDocument.eResource().unload();
    }

    protected void processFolder(IFolder folder, IProgressMonitor monitor) throws CoreException {
        IFileStore fs1;
        int filectr = 1;
        long currentProcessingTime = 1L;
        long totalBytes = 0L;
        long totalBytes2 = 0L;
        Stopwatch stopwatch = Stopwatch.createUnstarted();
        this.documents.clear();
        IResource[] iResourceArray = folder.members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (monitor.isCanceled()) {
                monitor.done();
                break;
            }
            if (resource instanceof IFolder && !resource.getName().equals("DeIndentified")) {
                this.processFolder((IFolder)resource, monitor);
            }
            if (resource instanceof IFile) {
                IFile file = (IFile)resource;
                EFS.getStore((java.net.URI)file.getLocationURI());
                if ("XML".equalsIgnoreCase(file.getFileExtension())) {
                    this.documents.add(file);
                    fs1 = EFS.getStore((java.net.URI)file.getLocationURI());
                    totalBytes += fs1.fetchInfo().getLength();
                }
            }
            ++n2;
        }
        totalBytes2 = totalBytes;
        monitor.setTaskName("DeIdentify Folder (" + format2Places.format((double)totalBytes2 / 1000000.0) + " MB) ");
        Comparator<IFile> c = new Comparator<IFile>(){

            @Override
            public int compare(IFile file1, IFile file2) {
                try {
                    IFileStore fs1 = EFS.getStore((java.net.URI)file1.getLocationURI());
                    IFileStore fs2 = EFS.getStore((java.net.URI)file2.getLocationURI());
                    if (fs1.fetchInfo().getLength() < fs2.fetchInfo().getLength()) {
                        return 1;
                    }
                    return -1;
                }
                catch (CoreException coreException) {
                    return 0;
                }
            }
        };
        Collections.sort(this.documents, c);
        currentProcessingTime = 0L;
        long estimatedTimeLeft = 0L;
        for (IFile document : this.documents) {
            monitor.worked(1);
            if (estimatedTimeLeft != 0L) {
                if (estimatedTimeLeft > 60L) {
                    monitor.setTaskName("DeIdentify Folder (" + format2Places.format((double)totalBytes2 / 1000000.0) + " MB), Estimated Time to finish : " + (int)estimatedTimeLeft / 60 + " Minutes ");
                } else {
                    monitor.setTaskName("DeIdentify Folder (" + format2Places.format((double)totalBytes2 / 1000000.0) + " MB), Estimated Time to finish : " + (int)estimatedTimeLeft + " Seconds ");
                }
            }
            fs1 = EFS.getStore((java.net.URI)document.getLocationURI());
            long fileSize = fs1.fetchInfo().getLength();
            monitor.subTask("Processing " + StringUtils.center((String)StringUtils.abbreviate((String)document.getName(), (int)16), (int)16) + "(" + format2Places.format((double)fs1.fetchInfo().getLength() / 1000000.0) + " MB)" + " File # " + StringUtils.center((String)String.valueOf(filectr++), (int)10) + " LAST " + StringUtils.center((String)String.valueOf((double)currentProcessingTime / 1000.0), (int)6) + " Seconds");
            try {
                stopwatch.reset();
                stopwatch.start();
                this.deidentifyCDA(document);
                stopwatch.stop();
                currentProcessingTime = stopwatch.elapsed(TimeUnit.MILLISECONDS);
                long ratePerSecond = fileSize / stopwatch.elapsed(TimeUnit.MILLISECONDS);
                totalBytes -= fileSize;
                if (ratePerSecond != 0L) {
                    estimatedTimeLeft = totalBytes / ratePerSecond / 1000L;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (monitor.isCanceled()) break;
        }
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        block7: {
            try {
                ProgressMonitorDialog pd = new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
                ISelection selection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
                if (!(selection instanceof IStructuredSelection)) break block7;
                final IStructuredSelection iss = (IStructuredSelection)selection;
                try {
                    pd.run(true, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            try {
                                Iterator iter = iss.iterator();
                                while (iter.hasNext() && !monitor.isCanceled()) {
                                    Object o = iter.next();
                                    if (o instanceof IFolder) {
                                        IFolder folder = (IFolder)o;
                                        monitor.beginTask("DeIdentify CDA Documents", folder.members().length);
                                        DeidentifyCDAHandler.this.processFolder(folder, monitor);
                                    }
                                    if (!(o instanceof IFile)) continue;
                                    DeidentifyCDAHandler.this.deidentifyCDA((IFile)o);
                                }
                            }
                            catch (PartInitException partInitException) {
                            }
                            catch (CoreException coreException) {
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    });
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                int n = iProjectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject project = iProjectArray[n2];
                    project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                    ++n2;
                }
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                Clipboard cb = new Clipboard(Display.getDefault());
                StringBuilder sb = new StringBuilder();
                for (String key : this.randomIds.keySet()) {
                    if (StringUtils.isEmpty((String)key)) continue;
                    sb.append(key).append(" = ").append(this.randomIds.get(key)).append('\r').append('\n');
                }
                TextTransfer textTransfer = TextTransfer.getInstance();
                cb.setContents(new Object[]{sb.toString()}, new Transfer[]{textTransfer});
                DeIdentificationDialog dlg = new DeIdentificationDialog(window.getShell());
                dlg.create();
                dlg.open();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public class DeIdentificationDialog
    extends TitleAreaDialog {
        Table table;

        public DeIdentificationDialog(Shell shell) {
            super(shell);
        }

        public void create() {
            super.create();
            this.setTitle("DeIdentification Results");
        }

        protected Control createDialogArea(Composite parent) {
            ScrolledComposite composite = new ScrolledComposite(parent, 512);
            composite.setLayout((Layout)new GridLayout());
            composite.setLayoutData((Object)new GridData(4, 4, true, true));
            this.table = new Table((Composite)composite, 2050);
            this.table.setHeaderVisible(true);
            this.table.setSize(100, 100);
            composite.setContent((Control)this.table);
            composite.setExpandHorizontal(true);
            composite.setExpandVertical(true);
            composite.setAlwaysShowScrollBars(true);
            composite.setMinSize(this.table.computeSize(-1, -1));
            this.table.setLinesVisible(true);
            GridData gridData = new GridData();
            gridData.widthHint = 500;
            this.table.setLayoutData((Object)gridData);
            this.table.setHeaderVisible(true);
            TableColumn column1 = new TableColumn(this.table, 16384);
            TableColumn column2 = new TableColumn(this.table, 16384);
            column1.setText("File Name");
            column2.setText("Size (MB)");
            column1.setWidth(250);
            column2.setWidth(250);
            for (IFile file : DeidentifyCDAHandler.this.documents) {
                try {
                    IFileStore fs1 = EFS.getStore((java.net.URI)file.getLocationURI());
                    TableItem valueSetsUpdatedItem = new TableItem(this.table, 0);
                    valueSetsUpdatedItem.setText(new String[]{fs1.fetchInfo().getName(), String.valueOf(fs1.fetchInfo().getLength() / 1000000L)});
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
            return composite;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            Button okButton = this.createButton(parent, 0, "Ok", false);
            okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DeIdentificationDialog.this.setReturnCode(0);
                    DeIdentificationDialog.this.close();
                }
            });
        }
    }
}

